/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnObjectCoordinate
implements FStruct {
    public byte[] strObjID;
    public byte[] strObjParentID;
    public BigInteger iPosX;
    public BigInteger iPosY;

    public AsnObjectCoordinate() {
    }

    public AsnObjectCoordinate(AsnObjectCoordinate arg) {
        this.strObjID = new byte[arg.strObjID.length];
        System.arraycopy(arg.strObjID, 0, this.strObjID, 0, arg.strObjID.length);
        this.strObjParentID = new byte[arg.strObjParentID.length];
        System.arraycopy(arg.strObjParentID, 0, this.strObjParentID, 0, arg.strObjParentID.length);
        this.iPosX = arg.iPosX;
        this.iPosY = arg.iPosY;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strObjID);
        enc.serializeOctetString(this.strObjParentID);
        enc.serializeInteger(this.iPosX);
        enc.serializeInteger(this.iPosY);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strObjID = dec.deserializeOctetString();
        this.strObjParentID = dec.deserializeOctetString();
        this.iPosX = dec.deserializeInteger();
        this.iPosY = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strObjParentID = ");
        os.print(FStruFormat.convertToString((byte[])this.strObjParentID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPosX = ");
        os.print(this.iPosX.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPosY = ");
        os.print(this.iPosY.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

