/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnMiniLinkTab
implements FStruct {
    public byte[] strLinkID;
    public int iViewID;
    public byte[] strLeftObjID;
    public byte[] strRightObjID;
    public int iLinkType;
    public int iLinkClass;

    public AsnMiniLinkTab() {
    }

    public AsnMiniLinkTab(AsnMiniLinkTab arg) {
        this.strLinkID = new byte[arg.strLinkID.length];
        System.arraycopy(arg.strLinkID, 0, this.strLinkID, 0, arg.strLinkID.length);
        this.iViewID = arg.iViewID;
        this.strLeftObjID = new byte[arg.strLeftObjID.length];
        System.arraycopy(arg.strLeftObjID, 0, this.strLeftObjID, 0, arg.strLeftObjID.length);
        this.strRightObjID = new byte[arg.strRightObjID.length];
        System.arraycopy(arg.strRightObjID, 0, this.strRightObjID, 0, arg.strRightObjID.length);
        this.iLinkType = arg.iLinkType;
        this.iLinkClass = arg.iLinkClass;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strLinkID);
        enc.serializeInteger(this.iViewID);
        enc.serializeOctetString(this.strLeftObjID);
        enc.serializeOctetString(this.strRightObjID);
        enc.serializeInteger(this.iLinkType);
        enc.serializeInteger(this.iLinkClass);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strLinkID = dec.deserializeOctetString();
        this.iViewID = dec.deserializeIntegerAsInt();
        this.strLeftObjID = dec.deserializeOctetString();
        this.strRightObjID = dec.deserializeOctetString();
        this.iLinkType = dec.deserializeIntegerAsInt();
        this.iLinkClass = dec.deserializeIntegerAsInt();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLinkID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLinkID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iViewID = ");
        os.print(this.iViewID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLeftObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLeftObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strRightObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strRightObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLinkType = ");
        os.print(this.iLinkType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLinkClass = ");
        os.print(this.iLinkClass);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

