/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnMapIfCustomData
implements FStruct {
    public BigInteger iUserID;
    public BigInteger iShowLinkMode;
    public BigInteger iMultiViewMode;
    public byte[] strDftSubmapID;

    public AsnMapIfCustomData() {
    }

    public AsnMapIfCustomData(AsnMapIfCustomData arg) {
        this.iUserID = arg.iUserID;
        this.iShowLinkMode = arg.iShowLinkMode;
        this.iMultiViewMode = arg.iMultiViewMode;
        this.strDftSubmapID = new byte[arg.strDftSubmapID.length];
        System.arraycopy(arg.strDftSubmapID, 0, this.strDftSubmapID, 0, arg.strDftSubmapID.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iUserID);
        enc.serializeInteger(this.iShowLinkMode);
        enc.serializeInteger(this.iMultiViewMode);
        enc.serializeOctetString(this.strDftSubmapID);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iUserID = dec.deserializeInteger();
        this.iShowLinkMode = dec.deserializeInteger();
        this.iMultiViewMode = dec.deserializeInteger();
        this.strDftSubmapID = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUserID = ");
        os.print(this.iUserID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iShowLinkMode = ");
        os.print(this.iShowLinkMode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iMultiViewMode = ");
        os.print(this.iMultiViewMode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDftSubmapID = ");
        os.print(FStruFormat.convertToString((byte[])this.strDftSubmapID));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

