/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnCmdRsp
implements FStruct {
    public BigInteger iComCode;
    public BigInteger iResult;
    public byte[] strFrameContent;

    public AsnCmdRsp() {
    }

    public AsnCmdRsp(AsnCmdRsp arg) {
        this.iComCode = arg.iComCode;
        this.iResult = arg.iResult;
        this.strFrameContent = new byte[arg.strFrameContent.length];
        System.arraycopy(arg.strFrameContent, 0, this.strFrameContent, 0, arg.strFrameContent.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iComCode);
        enc.serializeInteger(this.iResult);
        enc.serializeOctetString(this.strFrameContent);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iComCode = dec.deserializeInteger();
        this.iResult = dec.deserializeInteger();
        this.strFrameContent = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iComCode = ");
        os.print(this.iComCode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResult = ");
        os.print(this.iResult.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFrameContent = ");
        os.print(FStruFormat.convertToString((byte[])this.strFrameContent));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

