/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnCmdReq
implements FStruct {
    public BigInteger iComCode;
    public BigInteger iComType;
    public byte[] strFrameContent = null;

    public AsnCmdReq() {
    }

    public AsnCmdReq(AsnCmdReq arg) {
        this.iComCode = arg.iComCode;
        this.iComType = arg.iComType;
        if (arg.strFrameContent != null) {
            this.strFrameContent = new byte[arg.strFrameContent.length];
            System.arraycopy(arg.strFrameContent, 0, this.strFrameContent, 0, arg.strFrameContent.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iComCode);
        enc.serializeInteger(this.iComType);
        if (this.strFrameContent != null) {
            enc.serializeOctetString(this.strFrameContent);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iComCode = dec.deserializeInteger();
        this.iComType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strFrameContent = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iComCode = ");
        os.print(this.iComCode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iComType = ");
        os.print(this.iComType.toString());
        os.println(',');
        if (this.strFrameContent != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strFrameContent = ");
            os.print(FStruFormat.convertToString((byte[])this.strFrameContent));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

