/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.topo;

import com.swimap.imap.common.asn1.common.AsnTopoStatus;
import com.swimap.imap.common.asn1.topo.AsnBaseLinkTabSeqOf;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnBaseLinkTab
implements FStruct {
    public int iObjID;
    public byte[] strLinkID;
    public byte[] strLabel;
    public int iLinkType;
    public AsnTopoStatus oStatus = new AsnTopoStatus();
    public byte[] strLeftObjID;
    public byte[] strRightObjID;
    public byte[] strLeftPortID;
    public byte[] strRightPortID;
    public int iAppProcID;
    public int iViewID;
    public AsnBaseLinkTabSeqOf lstAttr = null;
    public int iLineWidth;
    public int iLineType;
    public int iDirection;
    public int iLinkClass;
    public int iCheckSum;

    public AsnBaseLinkTab() {
    }

    public AsnBaseLinkTab(AsnBaseLinkTab arg) {
        this.iObjID = arg.iObjID;
        this.strLinkID = new byte[arg.strLinkID.length];
        System.arraycopy(arg.strLinkID, 0, this.strLinkID, 0, arg.strLinkID.length);
        this.strLabel = new byte[arg.strLabel.length];
        System.arraycopy(arg.strLabel, 0, this.strLabel, 0, arg.strLabel.length);
        this.iLinkType = arg.iLinkType;
        this.oStatus = new AsnTopoStatus(arg.oStatus);
        this.strLeftObjID = new byte[arg.strLeftObjID.length];
        System.arraycopy(arg.strLeftObjID, 0, this.strLeftObjID, 0, arg.strLeftObjID.length);
        this.strRightObjID = new byte[arg.strRightObjID.length];
        System.arraycopy(arg.strRightObjID, 0, this.strRightObjID, 0, arg.strRightObjID.length);
        this.strLeftPortID = new byte[arg.strLeftPortID.length];
        System.arraycopy(arg.strLeftPortID, 0, this.strLeftPortID, 0, arg.strLeftPortID.length);
        this.strRightPortID = new byte[arg.strRightPortID.length];
        System.arraycopy(arg.strRightPortID, 0, this.strRightPortID, 0, arg.strRightPortID.length);
        this.iAppProcID = arg.iAppProcID;
        this.iViewID = arg.iViewID;
        this.lstAttr = new AsnBaseLinkTabSeqOf(arg.lstAttr);
        this.iLineWidth = arg.iLineWidth;
        this.iLineType = arg.iLineType;
        this.iDirection = arg.iDirection;
        this.iLinkClass = arg.iLinkClass;
        this.iCheckSum = arg.iCheckSum;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iObjID);
        enc.serializeOctetString(this.strLinkID);
        enc.serializeOctetString(this.strLabel);
        enc.serializeInteger(this.iLinkType);
        this.oStatus.serialize(enc);
        enc.serializeOctetString(this.strLeftObjID);
        enc.serializeOctetString(this.strRightObjID);
        enc.serializeOctetString(this.strLeftPortID);
        enc.serializeOctetString(this.strRightPortID);
        enc.serializeInteger(this.iAppProcID);
        enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
        enc.serializeInteger(this.iViewID);
        if (this.lstAttr != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.lstAttr.serialize(enc);
        }
        enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
        enc.serializeInteger(this.iLineWidth);
        enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
        enc.serializeInteger(this.iLineType);
        enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
        enc.serializeInteger(this.iDirection);
        enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
        enc.serializeInteger(this.iLinkClass);
        enc.serializeInteger(this.iCheckSum);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iObjID = dec.deserializeIntegerAsInt();
        this.strLinkID = dec.deserializeOctetString();
        this.strLabel = dec.deserializeOctetString();
        this.iLinkType = dec.deserializeIntegerAsInt();
        this.oStatus.deserialize(dec);
        this.strLeftObjID = dec.deserializeOctetString();
        this.strRightObjID = dec.deserializeOctetString();
        this.strLeftPortID = dec.deserializeOctetString();
        this.strRightPortID = dec.deserializeOctetString();
        this.iAppProcID = dec.deserializeIntegerAsInt();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.iViewID = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.lstAttr = new AsnBaseLinkTabSeqOf();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.lstAttr.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.iLineWidth = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.iLineType = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.iDirection = dec.deserializeIntegerAsInt();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            this.iLinkClass = dec.deserializeIntegerAsInt();
        }
        this.iCheckSum = dec.deserializeIntegerAsInt();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iObjID = ");
        os.print(this.iObjID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLinkID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLinkID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLabel = ");
        os.print(FStruFormat.convertToString((byte[])this.strLabel));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLinkType = ");
        os.print(this.iLinkType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oStatus = ");
        this.oStatus.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLeftObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLeftObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strRightObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strRightObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLeftPortID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLeftPortID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strRightPortID = ");
        os.print(FStruFormat.convertToString((byte[])this.strRightPortID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iAppProcID = ");
        os.print(this.iAppProcID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iViewID = ");
        os.print(this.iViewID);
        os.println(',');
        if (this.lstAttr != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("lstAttr = ");
            this.lstAttr.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLineWidth = ");
        os.print(this.iLineWidth);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLineType = ");
        os.print(this.iLineType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDirection = ");
        os.print(this.iDirection);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLinkClass = ");
        os.print(this.iLinkClass);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iCheckSum = ");
        os.print(this.iCheckSum);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

