/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.asnprogress;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnProgressReturn
implements FStruct {
    public boolean bSuccess;
    public BigInteger retCode;
    public byte[] reason = null;

    public AsnProgressReturn() {
    }

    public AsnProgressReturn(AsnProgressReturn arg) {
        this.bSuccess = arg.bSuccess;
        this.retCode = arg.retCode;
        if (arg.reason != null) {
            this.reason = new byte[arg.reason.length];
            System.arraycopy(arg.reason, 0, this.reason, 0, arg.reason.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeBoolean(this.bSuccess);
        enc.serializeInteger(this.retCode);
        if (this.reason != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.reason);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.bSuccess = dec.deserializeBoolean();
        this.retCode = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.reason = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bSuccess = ");
        os.print(this.bSuccess);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("retCode = ");
        os.print(this.retCode.toString());
        os.println(',');
        if (this.reason != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("reason = ");
            os.print(FStruFormat.convertToString((byte[])this.reason));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

