/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.asnprogress;

import com.swimap.imap.common.asn1.asnprogress.AsnProgressDetailList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnProgressReport
implements FStruct {
    public BigInteger missionID;
    public BigInteger progress;
    public byte[] processInfo = null;
    public AsnProgressDetailList detailList = new AsnProgressDetailList();

    public AsnProgressReport() {
    }

    public AsnProgressReport(AsnProgressReport arg) {
        this.missionID = arg.missionID;
        this.progress = arg.progress;
        if (arg.processInfo != null) {
            this.processInfo = new byte[arg.processInfo.length];
            System.arraycopy(arg.processInfo, 0, this.processInfo, 0, arg.processInfo.length);
        }
        this.detailList = new AsnProgressDetailList(arg.detailList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.missionID);
        enc.serializeInteger(this.progress);
        if (this.processInfo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.processInfo);
        }
        this.detailList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.missionID = dec.deserializeInteger();
        this.progress = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.processInfo = dec.deserializeOctetString();
        }
        this.detailList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("missionID = ");
        os.print(this.missionID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("progress = ");
        os.print(this.progress.toString());
        os.println(',');
        if (this.processInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("processInfo = ");
            os.print(FStruFormat.convertToString((byte[])this.processInfo));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("detailList = ");
        this.detailList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

