/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.general.timelocalization;

import com.swimap.external.sf.general.timelocalization.GeneralDSTInfo;
import com.swimap.external.sf.general.timelocalization.GeneralDayLightDate;
import com.swimap.iview.util.DebugTracer;
import java.util.TimeZone;

public class GeneralZoneToDSTInfo {
    private TimeZone _tz = null;
    private GeneralDSTInfo _dstinfo = null;
    private GeneralDayLightDate startDayLightDate = null;
    private GeneralDayLightDate endDayLightDate = null;
    private static final String DST_OFFSET = "dstSavings";
    private static final String S_MODE = "startMode";
    private static final String S_MONTH = "startMonth";
    private static final String S_DAY = "startDay";
    private static final String S_WEEKDAY = "startDayOfWeek";
    private static final String S_TIMEMODE = "startTimeMode";
    private static final String S_TIME = "startTime";
    private static final String E_MODE = "endMode";
    private static final String E_MONTH = "endMonth";
    private static final String E_DAY = "endDay";
    private static final String E_WEEKDAY = "endDayOfWeek";
    private static final String E_TIMEMODE = "endTimeMode";
    private static final String E_TIME = "endTime";
    private static final String ZONE_OFFSET = "offset";
    private static final int LAST_WEEK = 5;
    private static final int DST_DATE = 1;
    private static final int DST_WEEK_DAY = 3;
    private static final int DST_LASTWEEK = 2;
    private static final int UTC_TIME = 2;
    private static final int STD_TIME = 1;
    private static final int MSELOFHOUR = 3600000;
    private static final int MSELOFMINUTE = 60000;

    public GeneralZoneToDSTInfo(TimeZone tzInfo) {
        if (tzInfo != null) {
            this._tz = tzInfo;
        }
    }

    public GeneralZoneToDSTInfo(String tzName) {
        try {
            this._tz = TimeZone.getTimeZone(tzName);
        }
        catch (Exception ex) {
            DebugTracer.trace((Exception)ex);
        }
    }

    public GeneralZoneToDSTInfo() {
        this._tz = TimeZone.getDefault();
    }

    public GeneralDSTInfo getDSTInfo() {
        if (this.zoneToDSTInfo()) {
            return this._dstinfo;
        }
        return null;
    }

    protected boolean zoneToDSTInfo() {
        if (this._tz == null) {
            return false;
        }
        try {
            if (this._tz.useDaylightTime()) {
                int ms;
                String strDSTRule = this._tz.toString();
                int index = 0;
                index = strDSTRule.indexOf(DST_OFFSET);
                String dstSavings = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(ZONE_OFFSET);
                String offset = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(S_MODE);
                String startMode = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(S_MONTH);
                String startMonth = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(S_DAY);
                String startDay = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(S_WEEKDAY);
                String startDayOfWeek = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(S_TIMEMODE);
                String startTimeMode = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(S_TIME);
                String startTime = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(E_MODE);
                String endMode = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(E_MONTH);
                String endMonth = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(E_DAY);
                String endDay = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(E_WEEKDAY);
                String endDayOfWeek = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                index = strDSTRule.indexOf(E_TIMEMODE);
                String endTimeMode = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(93, index));
                index = strDSTRule.indexOf(E_TIME);
                String endTime = strDSTRule.substring(strDSTRule.indexOf(61, index) + 1, strDSTRule.indexOf(44, index));
                this._dstinfo = new GeneralDSTInfo();
                this.startDayLightDate = this._dstinfo.getStartDayLightDate();
                this.endDayLightDate = this._dstinfo.getEndDayLightDate();
                this._dstinfo.setOffset(Integer.parseInt(dstSavings) / 60000);
                switch (Integer.parseInt(startMode)) {
                    case 1: {
                        this.startDayLightDate.setG_iDayLightType(0);
                        this.startDayLightDate.setG_iMonth(Integer.parseInt(startMonth) + 1);
                        this.startDayLightDate.setG_iDay(Integer.parseInt(startDay));
                        this.startDayLightDate.setG_iHour(Integer.parseInt(startTime) / 3600000);
                        this.startDayLightDate.setG_iMinute(Integer.parseInt(startTime) % 3600000 / 60000);
                        break;
                    }
                    case 2: {
                        this.startDayLightDate.setG_iDayLightType(1);
                        this.startDayLightDate.setG_iMonth(Integer.parseInt(startMonth) + 1);
                        this.startDayLightDate.setG_iDayOfWeek(Integer.parseInt(startDayOfWeek));
                        this.startDayLightDate.setG_iWeekOfMonth(5);
                        this.startDayLightDate.setG_iHour(Integer.parseInt(startTime) / 3600000);
                        this.startDayLightDate.setG_iMinute(Integer.parseInt(startTime) % 3600000 / 60000);
                        break;
                    }
                    case 3: {
                        this.startDayLightDate.setG_iDayLightType(1);
                        this.startDayLightDate.setG_iMonth(Integer.parseInt(startMonth) + 1);
                        this.startDayLightDate.setG_iWeekOfMonth(Integer.parseInt(startDay) / 7 + 1);
                        this.startDayLightDate.setG_iDayOfWeek(Integer.parseInt(startDayOfWeek));
                        this.startDayLightDate.setG_iHour(Integer.parseInt(startTime) / 3600000);
                        this.startDayLightDate.setG_iMinute(Integer.parseInt(startTime) % 3600000 / 60000);
                        if (Integer.parseInt(startTimeMode) != 2) break;
                        ms = Integer.parseInt(startTime) + Integer.parseInt(offset);
                        if (ms >= 0) {
                            this.startDayLightDate.setG_iHour(ms / 3600000);
                            this.startDayLightDate.setG_iMinute(ms % 3600000 / 60000);
                            break;
                        }
                        this.startDayLightDate.setG_iHour((ms + 86400000) / 3600000);
                        this.startDayLightDate.setG_iMinute((ms + 86400000) % 3600000 / 60000);
                        if (Integer.parseInt(startDayOfWeek) - 1 > 0) {
                            this.startDayLightDate.setG_iDayOfWeek(Integer.parseInt(startDayOfWeek) - 1);
                            break;
                        }
                        if (Integer.parseInt(startDay) / 7 > 0) {
                            this.startDayLightDate.setG_iDayOfWeek(Integer.parseInt(startDayOfWeek) + 6);
                            this.startDayLightDate.setG_iWeekOfMonth(Integer.parseInt(startDay) / 7);
                            break;
                        }
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                switch (Integer.parseInt(endMode)) {
                    case 1: {
                        this.endDayLightDate.setG_iDayLightType(0);
                        this.endDayLightDate.setG_iMonth(Integer.parseInt(endMonth) + 1);
                        this.endDayLightDate.setG_iDay(Integer.parseInt(endDay));
                        this.endDayLightDate.setG_iHour(Integer.parseInt(endTime) / 3600000);
                        this.endDayLightDate.setG_iMinute(Integer.parseInt(endTime) % 3600000 / 60000);
                        break;
                    }
                    case 3: {
                        this.endDayLightDate.setG_iDayLightType(1);
                        this.endDayLightDate.setG_iMonth(Integer.parseInt(endMonth) + 1);
                        this.endDayLightDate.setG_iWeekOfMonth(Integer.parseInt(endDay) / 7 + 1);
                        this.endDayLightDate.setG_iDayOfWeek(Integer.parseInt(endDayOfWeek));
                        this.endDayLightDate.setG_iHour(Integer.parseInt(endTime) / 3600000);
                        this.endDayLightDate.setG_iMinute(Integer.parseInt(endTime) % 3600000 / 60000);
                        if (Integer.parseInt(endTimeMode) == 2) {
                            ms = Integer.parseInt(endTime) + Integer.parseInt(offset) + Integer.parseInt(dstSavings);
                            if (ms >= 0) {
                                this.endDayLightDate.setG_iHour(ms / 3600000);
                                this.endDayLightDate.setG_iMinute(ms % 3600000 / 60000);
                            } else {
                                this.endDayLightDate.setG_iHour((ms + 86400000) / 3600000);
                                this.endDayLightDate.setG_iMinute((ms + 86400000) % 3600000 / 60000);
                                if (Integer.parseInt(endDayOfWeek) - 1 > 0) {
                                    this.endDayLightDate.setG_iDayOfWeek(Integer.parseInt(endDayOfWeek) - 1);
                                } else if (Integer.parseInt(endDay) / 7 > 0) {
                                    this.endDayLightDate.setG_iDayOfWeek(Integer.parseInt(endDayOfWeek) + 6);
                                    this.endDayLightDate.setG_iWeekOfMonth(Integer.parseInt(endDay) / 7);
                                } else {
                                    return false;
                                }
                            }
                        }
                        if (Integer.parseInt(endTimeMode) != 1) break;
                        ms = Integer.parseInt(endTime) + Integer.parseInt(dstSavings);
                        if (ms >= 0) {
                            this.endDayLightDate.setG_iHour(ms / 3600000);
                            this.endDayLightDate.setG_iMinute(ms % 3600000 / 60000);
                            break;
                        }
                        return false;
                    }
                    case 2: {
                        this.endDayLightDate.setG_iDayLightType(1);
                        this.endDayLightDate.setG_iMonth(Integer.parseInt(endMonth) + 1);
                        this.endDayLightDate.setG_iDayOfWeek(Integer.parseInt(endDayOfWeek));
                        this.endDayLightDate.setG_iWeekOfMonth(5);
                        this.endDayLightDate.setG_iHour(Integer.parseInt(endTime) / 3600000);
                        this.endDayLightDate.setG_iMinute(Integer.parseInt(endTime) % 3600000 / 60000);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this._dstinfo.setStartDayLightDate(this.startDayLightDate);
                this._dstinfo.setEndDayLightDate(this.endDayLightDate);
            }
        }
        catch (Exception ex) {
            DebugTracer.trace((Exception)ex);
        }
        return true;
    }
}

