/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.general.timelocalization;

import com.swimap.external.eam.client.EamClientInterface;
import com.swimap.external.eam.client.util.timelocalization.EamGeneralDSTInfo;
import com.swimap.external.sf.general.GeneralCommonUtils;
import com.swimap.external.sf.general.timelocalization.GeneralDSTInfo;
import com.swimap.external.sf.general.timelocalization.GeneralDayLightDate;
import com.swimap.iview.framework.Main;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class GeneralTimeInfoService {
    public static final int GET_SERVER_TIME = -1;

    public static TimeZone getUTCTimeZone() {
        return TimeZone.getTimeZone("GMT");
    }

    public static TimeZone getClientTimeZone() {
        return TimeZone.getDefault();
    }

    public static GeneralDSTInfo getDSTInfo(int neID) {
        EamClientInterface eam = (EamClientInterface)Main.instance().getModuleManager().getLocalModule("eam");
        EamGeneralDSTInfo eamDSTInfo = eam.getDSTInfo(String.valueOf(neID));
        if (eamDSTInfo == null) {
            return null;
        }
        GeneralDSTInfo dstInfo = new GeneralDSTInfo();
        dstInfo.setOffset(eamDSTInfo.getOffset());
        dstInfo.setStartDayLightDate(GeneralCommonUtils.convertEam2GeneralDayLightDate(eamDSTInfo.getStartDayLightDate()));
        dstInfo.setEndDayLightDate(GeneralCommonUtils.convertEam2GeneralDayLightDate(eamDSTInfo.getEndDayLightDate()));
        return dstInfo;
    }

    public static Calendar getUTCCalendar() {
        return Calendar.getInstance(GeneralTimeInfoService.getUTCTimeZone());
    }

    public static Calendar getLocaleCalendar() {
        return Calendar.getInstance();
    }

    public static int getClientTimeZoneOffset() {
        return GeneralTimeInfoService.getClientTimeZone().getRawOffset();
    }

    public static int getServerTimeZoneOffset() {
        return GeneralTimeInfoService.getServerTimeZone().getRawOffset();
    }

    public static int getTimeZoneOffset(Calendar cal) {
        return cal.getTimeZone().getRawOffset();
    }

    public static int getClientDSTOffset() {
        return GeneralTimeInfoService.getClientTimeZone().getDSTSavings();
    }

    public static int getDSTOffset(Calendar cal) {
        return cal.getTimeZone().getDSTSavings();
    }

    public static boolean inDST(Calendar cal) {
        return cal.getTimeZone().inDaylightTime(cal.getTime());
    }

    public static boolean inDST(Date date, GeneralDSTInfo dstInfo) {
        GeneralDayLightDate start = dstInfo.getStartDayLightDate();
        GeneralDayLightDate end = dstInfo.getEndDayLightDate();
        SimpleTimeZone timeZone = new SimpleTimeZone(28800000, "GMT(+08:00)");
        timeZone.setDSTSavings(3600000);
        int startTime = ((start.getG_iHour() * 60 + start.getG_iMinute()) * 60 + start.getG_iSecond()) * 1000;
        int startDSTType = start.getG_iDayLightType();
        if (startDSTType == 0) {
            timeZone.setStartRule(start.getG_iMonth(), start.getG_iDay(), startTime);
        } else if (startDSTType == 1) {
            if (start.getG_iWeekOfMonth() == 5) {
                timeZone.setStartRule(start.getG_iMonth(), -1, start.getG_iDayOfWeek(), startTime);
            } else {
                timeZone.setStartRule(start.getG_iMonth(), start.getG_iWeekOfMonth(), start.getG_iDayOfWeek(), startTime);
            }
        } else if (startDSTType == 1) {
            timeZone.setStartRule(start.getG_iMonth(), start.getG_iDay(), -start.getG_iDayOfWeek(), startTime);
        }
        int endTime = ((end.getG_iHour() * 60 + end.getG_iMinute()) * 60 + end.getG_iSecond()) * 1000;
        int endDSTType = end.getG_iDayLightType();
        if (endDSTType == 0) {
            timeZone.setEndRule(end.getG_iMonth(), end.getG_iDay(), endTime);
        } else if (endDSTType == 1) {
            if (end.getG_iWeekOfMonth() == 5) {
                timeZone.setEndRule(end.getG_iMonth(), -1, end.getG_iDayOfWeek(), endTime);
            } else {
                timeZone.setEndRule(end.getG_iMonth(), end.getG_iWeekOfMonth(), end.getG_iDayOfWeek(), endTime);
            }
        } else if (endDSTType == 1) {
            timeZone.setEndRule(end.getG_iMonth(), end.getG_iDay(), -end.getG_iDayOfWeek(), endTime);
        }
        return timeZone.inDaylightTime(date);
    }

    public static TimeZone getServerTimeZone() {
        EamClientInterface eam = (EamClientInterface)Main.instance().getModuleManager().getLocalModule("eam");
        return eam.getServerTimeZone();
    }
}

