/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sf.general.timelocalization;

import com.swimap.external.sf.general.timelocalization.GeneralDateTimeType;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GeneralTimeConvertService {
    public static Calendar convertToCalendar(GeneralDateTimeType dtt) {
        Calendar calendar = Calendar.getInstance();
        if (dtt == null) {
            return calendar;
        }
        calendar.set(dtt.year, dtt.month - 1, dtt.day, dtt.hour, dtt.minute, dtt.second);
        calendar.set(16, dtt.offSet);
        return calendar;
    }

    public static GeneralDateTimeType convertToDateTimeType(Calendar calendar) {
        GeneralDateTimeType dtt = new GeneralDateTimeType();
        if (calendar == null) {
            dtt.year = 2100;
            dtt.month = 12;
            dtt.day = 31;
            dtt.hour = 0;
            dtt.minute = 0;
            dtt.second = 0;
            return dtt;
        }
        dtt.year = calendar.get(1);
        dtt.month = calendar.get(2) + 1;
        dtt.day = calendar.get(5);
        dtt.hour = calendar.get(11);
        dtt.minute = calendar.get(12);
        dtt.second = calendar.get(13);
        dtt.offSet = calendar.get(16);
        return dtt;
    }

    public static Calendar localeTime2CalendarUTC(GeneralDateTimeType dtt) {
        GregorianCalendar srcCalendar = null;
        if (dtt == null) {
            srcCalendar = new GregorianCalendar(TimeZone.getDefault());
            srcCalendar.set(1, 2100);
            srcCalendar.set(2, 11);
            srcCalendar.set(5, 31);
            srcCalendar.set(11, 0);
            srcCalendar.set(12, 0);
            srcCalendar.set(13, 0);
            srcCalendar.set(16, 0);
        } else {
            srcCalendar = new GregorianCalendar(TimeZone.getDefault());
            srcCalendar.set(1, dtt.year);
            srcCalendar.set(2, dtt.month - 1);
            srcCalendar.set(5, dtt.day);
            srcCalendar.set(11, dtt.hour);
            srcCalendar.set(12, dtt.minute);
            srcCalendar.set(13, dtt.second);
            srcCalendar.set(16, dtt.offSet);
        }
        GeneralTimeConvertService.switchGMTCalendar(srcCalendar);
        return srcCalendar;
    }

    public static GeneralDateTimeType localeTime2DateTimeTypeUTC(GeneralDateTimeType srcDtt) {
        Calendar calendar = GeneralTimeConvertService.localeTime2CalendarUTC(srcDtt);
        return GeneralTimeConvertService.convertToDateTimeType(calendar);
    }

    public static Date switch2GMTCalendar(Calendar srcCalendar) {
        if (srcCalendar == null) {
            srcCalendar = new GregorianCalendar(2100, 11, 31, 0, 0, 0);
        }
        GeneralTimeConvertService.switchGMTCalendar(srcCalendar);
        return srcCalendar.getTime();
    }

    public static Calendar utc2LocaleCalendar(GeneralDateTimeType dtt) {
        if (dtt == null) {
            dtt = new GeneralDateTimeType();
            dtt.year = 2100;
            dtt.month = 12;
            dtt.day = 31;
            dtt.hour = 0;
            dtt.minute = 0;
            dtt.second = 0;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(1, dtt.year);
        calendar.set(2, dtt.month - 1);
        calendar.set(5, dtt.day);
        calendar.set(11, dtt.hour);
        calendar.set(12, dtt.minute);
        calendar.set(13, dtt.second);
        GeneralTimeConvertService.switchLocalCalendar(calendar);
        return calendar;
    }

    public static GeneralDateTimeType utc2LocaleDateTimeType(GeneralDateTimeType dtt) {
        return GeneralTimeConvertService.convertToDateTimeType(GeneralTimeConvertService.utc2LocaleCalendar(dtt));
    }

    public static Date switch2LocalCalendar(Calendar cal) {
        if (cal == null) {
            cal = new GregorianCalendar(2100, 11, 31, 0, 0, 0);
        }
        GeneralTimeConvertService.switchLocalCalendar(cal);
        return cal.getTime();
    }

    public static void switchLocalCalendar(Calendar srcCalendar) {
        TimeZone localZone = TimeZone.getDefault();
        GeneralTimeConvertService.switchCalendar(srcCalendar, localZone);
    }

    public static void switchGMTCalendar(Calendar srcCalendar) {
        TimeZone gmtZone = TimeZone.getTimeZone("GMT");
        GeneralTimeConvertService.switchCalendar(srcCalendar, gmtZone);
    }

    public static void switchCalendar(Calendar srcCalendar, TimeZone toZone) {
        if (srcCalendar == null || srcCalendar.getTimeZone() == null || toZone == null) {
            throw new IllegalArgumentException("The 'srcCalendar' and 'srcCalendar.getTimeZone()' and 'toZone' can not be null.");
        }
        srcCalendar.get(11);
        srcCalendar.setTimeZone(toZone);
        srcCalendar.get(11);
    }
}

