/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.ftpconf;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.ftpconf.IClientFileTransferInfo;
import com.swimap.ftpconf.ClientFileTransferInfo;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;

public class FTPSettingImp {
    private static final String SSH_PARANAME = "FileTransferMode";
    private static final String BREAKPOINT_PARANAME = "SupportBreakpoint";
    private static final String COMPRESS_PARANAME = "SupportCompress";
    private static final String PASSIVE_PARANAME = "SupportPassive";
    private static final String TIMEOUT_PARANAME = "Timeout";
    private static final String PARANAME_FTP = "FTP";
    private static final String PARANAME_SFTP = "SFTP";
    private static final IviewLogger log = IviewLogger.getLogger(FTPSettingImp.class, (String)"FRM");

    public static boolean setFileTransferSetting(IClientFileTransferInfo oClientFileTransferInfo) {
        if (null == oClientFileTransferInfo) {
            DebugTracer.trace((int)1, (String)"FTPSetting", (String)"setFileTransferSetting", (String)"the input parameter is null");
            throw new IllegalArgumentException();
        }
        DataTable dataTable = FTPSettingImp.createDataTable(oClientFileTransferInfo);
        return FTPSettingImp.saveProfile(dataTable);
    }

    public static DataTable createDataTable(IClientFileTransferInfo oClientFileTransferInfo) {
        DataTable dataTable = new DataTable("profileFileTable");
        String fileTransferMode = oClientFileTransferInfo.getMode() == 0 ? PARANAME_FTP : PARANAME_SFTP;
        dataTable.setColumns(new String[]{"name", "value"});
        dataTable.add(new Object[]{SSH_PARANAME, fileTransferMode});
        dataTable.add(new Object[]{TIMEOUT_PARANAME, Integer.toString(oClientFileTransferInfo.getTimeOut())});
        dataTable.add(new Object[]{BREAKPOINT_PARANAME, Boolean.toString(oClientFileTransferInfo.isBreakPoint())});
        dataTable.add(new Object[]{COMPRESS_PARANAME, Boolean.toString(oClientFileTransferInfo.isCompress())});
        dataTable.add(new Object[]{PASSIVE_PARANAME, Boolean.toString(oClientFileTransferInfo.isPassive())});
        return dataTable;
    }

    public static DataTable getProfile() {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sys.manage.profile.ds.getFTPSettings");
            log.info((Object)"sys | getProfile | req.invoke() start.");
            RpcResponse rsp = ClientUtilModule.invoker((RpcRequest)req);
            log.info((Object)"sys | getProfile | req.invoke() end.");
            RpcMessage msg = rsp.getMessage();
            return msg.getTable("FtpSettingsTable");
        }
        catch (Exception e) {
            log.debug((Object)"failed to get the ftp setting information.");
            return null;
        }
    }

    public static boolean saveProfile(DataTable data) {
        boolean isSuccess = true;
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sys.manage.profile.ds.saveFTPSettings");
            req.addTable(data);
            log.info((Object)"req.invoke() start.");
            RpcResponse rsp = ClientUtilModule.invoker((RpcRequest)req);
            log.info((Object)"req.invoke() end.");
            int errorCode = FTPSettingImp.getErrorCode(rsp);
            if (errorCode != 0) {
                return false;
            }
        }
        catch (Exception e) {
            isSuccess = false;
            log.debug((Object)"failed to save the ftp setting information.");
        }
        return isSuccess;
    }

    public static IClientFileTransferInfo getFileTransferSetting() {
        ClientFileTransferInfo info = null;
        DataTable dataTable = FTPSettingImp.getProfile();
        if (null != dataTable && dataTable.size() > 0) {
            info = FTPSettingImp.createFileTransferInfo(dataTable);
            return info;
        }
        info = new ClientFileTransferInfo();
        log.trace((Object)"FTP Setting configuration is not exist! use default settings.");
        return info;
    }

    private static ClientFileTransferInfo createFileTransferInfo(DataTable dataTable) {
        ClientFileTransferInfo info = new ClientFileTransferInfo();
        DataRecord dataRecord = null;
        String key = "";
        String value = "";
        try {
            for (int i = 0; i < dataTable.size(); ++i) {
                dataRecord = dataTable.get(i);
                key = dataRecord.get(0);
                value = dataRecord.get(1);
                if (SSH_PARANAME.equals(key)) {
                    String fileTransferMode = value;
                    if (PARANAME_SFTP.equals(fileTransferMode)) {
                        info.setMode(1);
                        continue;
                    }
                    info.setMode(0);
                    continue;
                }
                if (COMPRESS_PARANAME.equals(key)) {
                    info.setCompress(Boolean.valueOf(value));
                    continue;
                }
                if (PASSIVE_PARANAME.equals(key)) {
                    info.setPassive(Boolean.valueOf(value));
                    continue;
                }
                if (TIMEOUT_PARANAME.equals(key)) {
                    info.setTimeOut(Integer.valueOf(value));
                    continue;
                }
                if (BREAKPOINT_PARANAME.equals(key)) {
                    info.setBreakPoint(Boolean.valueOf(value));
                    continue;
                }
                log.debug((Object)(key + " was a incorrect key."));
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString());
        }
        return info;
    }

    public static int getErrorCode(RpcResponse rsp) {
        RpcMessage msg = rsp.getMessage();
        if (msg.hasParameter("errorCode")) {
            return msg.getInt("errorCode");
        }
        return -1;
    }
}

