/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.ftp.userprofile;

import com.swimap.external.ftpconf.IClientFileTransferInfo;
import com.swimap.external.sm.client.base.SessionService;
import com.swimap.ftp.userprofile.FtpSettingRes;
import com.swimap.ftpconf.ClientFileTransferInfo;
import com.swimap.ftpconf.FTPSettingImp;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.IntegerTextField;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.helpmanagement.HelpManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FtpSettingPanel
extends JPanel {
    private static final long serialVersionUID = 5860686995719203993L;
    private JPanel jPanel1 = new JPanel();
    private JRadioButton jRadioButton_Ftp = new JRadioButton();
    private JRadioButton jRadioButton_SFtp = new JRadioButton();
    private JCheckBox jCheckBox_Compress = new JCheckBox();
    private JCheckBox jCheckBox_BreakPoint = new JCheckBox();
    private ButtonGroup buttonGroup_FtpMode = new ButtonGroup();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private Border border9 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
    private Border border10 = new TitledBorder(this.border9, FtpSettingRes.getString("Ftp_Optional_Function"));
    private Border border11 = BorderFactory.createCompoundBorder(this.border10, BorderFactory.createEmptyBorder(15, 15, 15, 15));
    private Border border12 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
    private Border border13 = new TitledBorder(this.border12, FtpSettingRes.getString("Ftp_Mode"));
    private Border border14 = BorderFactory.createCompoundBorder(this.border13, BorderFactory.createEmptyBorder(15, 15, 15, 15));
    private GridLayout gridLayout1 = new GridLayout();
    private JCheckBox jCheckBox_ConnectionMode = new JCheckBox();
    private GridLayout gridLayout2 = new GridLayout();
    private JPanel jPanel_TimeOut = new JPanel();
    private JLabel jLabel_TimeOut = new JLabel();
    private final int MIN_VALUE_TIMEOUT = 5;
    private final int MAX_VALUE_TIMEOUT = 3600;
    private IntegerTextField jTextField_TimeOut = new IntegerTextField(5, 3600);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean isChanged = false;
    private String originalTimeOut;

    public FtpSettingPanel() {
        this.initComponent();
        this.initData();
        this.addListeners();
        this.setComponentsNameAuto();
        if (!this.checkRight()) {
            this.disabletComponents();
        }
    }

    private void initComponent() {
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(this.gridLayout2);
        this.jPanel3.setLayout(this.gridLayout1);
        this.jPanel3.setBorder(this.border11);
        this.jPanel2.setBorder(this.border14);
        this.jRadioButton_SFtp.setText(FtpSettingRes.getString("SFtp_Transfer_Mode"));
        this.jCheckBox_Compress.setText(FtpSettingRes.getString("Support_Compress"));
        this.jCheckBox_BreakPoint.setText(FtpSettingRes.getString("Support_BreakPoint"));
        this.jRadioButton_Ftp.setText(FtpSettingRes.getString("Ftp_Transfer_Mode"));
        this.jCheckBox_ConnectionMode.setText(FtpSettingRes.getString("FTP_Connect_PASV_Mode"));
        this.jLabel_TimeOut.setText(FtpSettingRes.getString("FTP_Network_TimeOut"));
        this.jPanel_TimeOut.setLayout(this.gridBagLayout1);
        this.buttonGroup_FtpMode.add(this.jRadioButton_SFtp);
        this.buttonGroup_FtpMode.add(this.jRadioButton_Ftp);
        this.jPanel3.add((Component)this.jCheckBox_BreakPoint, null);
        this.jPanel3.add((Component)this.jCheckBox_Compress, null);
        this.jPanel3.add(this.jCheckBox_ConnectionMode);
        this.jPanel2.add((Component)this.jRadioButton_Ftp, null);
        this.jPanel2.add((Component)this.jRadioButton_SFtp, null);
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 5, 2, 5), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 2, 5), 0, 0));
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 2, 5), 0, 0));
        this.jPanel1.add((Component)this.jPanel_TimeOut, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 2, 5), 0, 0));
        this.jPanel_TimeOut.add((Component)this.jLabel_TimeOut, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 50, 5));
        this.jPanel_TimeOut.add((Component)this.jTextField_TimeOut, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 3), 133, 0));
        HelpManager.getInstance().enableHelpKey((Component)this, "omc.SWM.FTPPARASETTING");
    }

    private void addListeners() {
        this.addButtonListener(this.jRadioButton_Ftp);
        this.addButtonListener(this.jRadioButton_SFtp);
        this.addButtonListener(this.jCheckBox_Compress);
        this.addButtonListener(this.jCheckBox_BreakPoint);
        this.addButtonListener(this.jCheckBox_ConnectionMode);
        this.addTextFiledListener(this.jTextField_TimeOut);
    }

    private void addButtonListener(AbstractButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FtpSettingPanel.this.setChanged(true);
                FrameworkUtilities.getPreferenceManager().notifyChanged();
            }
        });
    }

    private void addTextFiledListener(final IntegerTextField textField) {
        textField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (textField.getText().equals(FtpSettingPanel.this.originalTimeOut)) {
                    return;
                }
                FtpSettingPanel.this.setChanged(true);
                FrameworkUtilities.getPreferenceManager().notifyChanged();
            }
        });
    }

    private void setComponentsNameAuto() {
        Component[] comArray = new Component[]{this.jPanel1, this.jRadioButton_Ftp, this.jRadioButton_SFtp, this.jCheckBox_Compress, this.jCheckBox_BreakPoint, this.jPanel2, this.jPanel3, this.jCheckBox_ConnectionMode, this.jPanel_TimeOut, this.jLabel_TimeOut, this.jTextField_TimeOut};
        String[] nameArray = new String[]{"jPanel1", "jRadioButton_Ftp", "jRadioButton_SFtp", "jCheckBox_Compress", "jCheckBox_BreakPoint", "jPanel2", "jPanel3", "jCheckBox_ConnectionMode", "jPanel_TimeOut", "jLabel_TimeOut", "jTextField_TimeOut"};
        for (int i = 0; i < comArray.length; ++i) {
            if (null == comArray[i]) continue;
            String comName = "com_swimap_ftp_" + nameArray[i];
            comArray[i].setName(comName);
        }
    }

    private void disabletComponents() {
        this.jCheckBox_BreakPoint.setEnabled(false);
        this.jCheckBox_Compress.setEnabled(false);
        this.jCheckBox_ConnectionMode.setEnabled(false);
        this.jRadioButton_Ftp.setEnabled(false);
        this.jRadioButton_SFtp.setEnabled(false);
        this.jTextField_TimeOut.setEnabled(false);
    }

    public void initData() {
        IClientFileTransferInfo clientFileTransferInfo = FTPSettingImp.getFileTransferSetting();
        this.jCheckBox_Compress.setSelected(clientFileTransferInfo.isCompress());
        this.jCheckBox_BreakPoint.setSelected(clientFileTransferInfo.isBreakPoint());
        this.jRadioButton_Ftp.setSelected(clientFileTransferInfo.getMode() == 0);
        this.jRadioButton_SFtp.setSelected(clientFileTransferInfo.getMode() == 1);
        this.jCheckBox_ConnectionMode.setSelected(clientFileTransferInfo.isPassive());
        this.jTextField_TimeOut.setText(String.valueOf(clientFileTransferInfo.getTimeOut()));
        this.originalTimeOut = this.jTextField_TimeOut.getText();
        this.setChanged(false);
    }

    public void save() {
        SystemSettingsManager ssm = FrameworkUtilities.getSystemSettingsManager();
        if (!this.checkRight()) {
            this.disabletComponents();
            ssm.setSystemSettingStatus(FtpSettingRes.getString("Ftp_Parameters_Setting"), Boolean.valueOf(false), FtpSettingRes.getString("No_Saving_Right"));
            return;
        }
        ClientFileTransferInfo oFileTransferInfo = new ClientFileTransferInfo();
        if (this.jRadioButton_Ftp.isSelected()) {
            oFileTransferInfo.setMode(0);
        } else {
            oFileTransferInfo.setMode(1);
        }
        oFileTransferInfo.setCompress(this.jCheckBox_Compress.isSelected());
        oFileTransferInfo.setTimeOut(Integer.valueOf(this.jTextField_TimeOut.getText()));
        oFileTransferInfo.setBreakPoint(this.jCheckBox_BreakPoint.isSelected());
        oFileTransferInfo.setPassive(this.jCheckBox_ConnectionMode.isSelected());
        boolean isSuccess = FTPSettingImp.setFileTransferSetting(oFileTransferInfo);
        if (isSuccess) {
            this.originalTimeOut = this.jTextField_TimeOut.getText();
            ssm.setSystemSettingStatus(FtpSettingRes.getString("Ftp_Parameters_Setting"), Boolean.valueOf(true), null);
        } else {
            ssm.setSystemSettingStatus(FtpSettingRes.getString("Ftp_Parameters_Setting"), Boolean.valueOf(false), FtpSettingRes.getString("Saving_Failed"));
        }
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean checkRight() {
        boolean hasRight = false;
        SessionService ss = SessionService.getInstance();
        try {
            hasRight = ss.isAdminUserGroup();
        }
        catch (Exception e) {
            DebugTracer.trace((int)1, (String)"FtpSettingPanel", (String)"checkRight", (String)e.toString());
        }
        return hasRight;
    }
}

