/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.commustru.util.FStruFormat;

public class FormatedOutputStream
extends OutputStream {
    private final PrintWriter output;
    private int printCount;
    private boolean lineStart = true;
    int lineSize = 16;
    int separateSize = 1;
    int offset;
    String flushMarker = "";
    boolean upCase = true;

    public FormatedOutputStream() {
        this(new PrintWriter(System.out, true));
    }

    public FormatedOutputStream(OutputStream outputstream) {
        this(new PrintWriter(outputstream, true));
    }

    public FormatedOutputStream(PrintWriter printwriter) {
        this.output = printwriter;
    }

    public void newLine() {
        if (!this.lineStart) {
            this.addNewLine();
        }
    }

    public void reset() {
        this.printCount = 0;
        this.newLine();
    }

    private void addNewLine() {
        this.output.println();
        this.lineStart = true;
    }

    private void addBlank() {
        this.output.print(' ');
    }

    private void addOffsetLabel() {
        int labelLen = this.offset;
        char[] alphabet = this.upCase ? FStruFormat.UP_CASE_CHAR_DEF : FStruFormat.LOW_CASE_CHAR_DEF;
        while (labelLen > 0) {
            this.output.print(alphabet[this.printCount >>> --labelLen * 4 & 0xF]);
        }
        this.output.print(": ");
    }

    @Override
    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i});
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int beginIndex, int length) throws IOException {
        char[] alphabet = this.upCase ? FStruFormat.UP_CASE_CHAR_DEF : FStruFormat.LOW_CASE_CHAR_DEF;
        while (length > 0) {
            --length;
            if (this.lineStart && this.offset > 0) {
                this.addOffsetLabel();
            }
            this.lineStart = false;
            this.output.print(alphabet[bytes[beginIndex] >> 4 & 0xF]);
            this.output.print(alphabet[bytes[beginIndex] & 0xF]);
            ++this.printCount;
            if (this.lineSize > 0 && this.printCount % this.lineSize == 0) {
                this.addNewLine();
            } else if (this.separateSize > 0 && this.printCount % this.separateSize == 0) {
                this.addBlank();
            }
            ++beginIndex;
        }
    }

    @Override
    public void flush() {
        this.output.print(this.flushMarker);
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.reset();
        this.output.close();
    }
}

