/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.util;

public final class FStruFormat {
    public static final char[] UP_CASE_CHAR_DEF = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] LOW_CASE_CHAR_DEF = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private FStruFormat() {
    }

    public static String convertToString(byte[] bytes, int beginIndex, int length, boolean upperCase) {
        char[] alphabet = upperCase ? UP_CASE_CHAR_DEF : LOW_CASE_CHAR_DEF;
        StringBuffer stringbuffer = new StringBuffer(length * 2);
        int i = beginIndex;
        while (i < beginIndex + length) {
            stringbuffer.append(alphabet[(bytes[i] & 0xF0) >>> 4]);
            stringbuffer.append(alphabet[bytes[i] & 0xF]);
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String convertToString(byte[] bytes, int i, int j) {
        return FStruFormat.convertToString(bytes, i, j, true);
    }

    public static String convertToString(byte[] bytes, boolean upperCase) {
        return FStruFormat.convertToString(bytes, 0, bytes.length, upperCase);
    }

    public static String convertToString(byte[] bytes) {
        return FStruFormat.convertToString(bytes, 0, bytes.length, true);
    }

    public static byte[] convertToByteArray(String hexStrVal) {
        return FStruFormat.convertToByteArray(hexStrVal, 0, hexStrVal.length());
    }

    public static byte[] convertToByteArray(String hexStrVal, int beginIndex, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Illegal length of Hex encoding: " + length + " (not n*2)");
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length / 2];
        int charPair = 0;
        int i = beginIndex;
        while (i < beginIndex + length) {
            int charDigit = Character.digit(hexStrVal.charAt(i), 16);
            if (charDigit < 0) {
                throw new IllegalArgumentException("Illegal characters in Hex encoding: " + hexStrVal.charAt(i));
            }
            charPair = (charPair << 4) + charDigit;
            if (i % 2 == 1) {
                bytes[i / 2] = (byte)charPair;
            }
            ++i;
        }
        return bytes;
    }
}

