/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.fstru;

import net.commustru.fstru.FStruException;

public class Tags {
    private static final int TAGCLASS_SHIFTER = 30;
    private static final int TAGNUMBER_MASKER = 0x3FFFFFFF;
    private static final String[] TAG_CLASS_NAMES = new String[]{"Universal", "Application", "Context", "Private"};
    private static final String[] UNIVERSAL_TAG_NAMES = new String[]{"End-of-Indefinite-Encoding", "Boolean", "Integer", "Bit-String", "Octet-String", "Null", "Object-Identifier", "OD", "External", "Real", "Enumeration", "11", "12", "13", "14", "15", "Sequence (of)", "Set (of)", "Numeric-String", "Printable-String", "T61-String", "Teletex-String", "IA5-String", "UTC-Time", "Generalized-Time", "Graphic-String", "Visible-String", "General-String"};
    public static final int UNIVERSAL_TAG_BMPSTRING = 30;
    public static final int UNIVERSAL_TAG_GENERALSTRING = 27;
    public static final int UNIVERSAL_TAG_VISIBLESTRING = 26;
    public static final int UNIVERSAL_TAG_GRAPHICSTRING = 25;
    public static final int UNIVERSAL_TAG_GENERALIZEDTIME = 24;
    public static final int UNIVERSAL_TAG_UTCTIME = 23;
    public static final int UNIVERSAL_TAG_IA5STRING = 22;
    public static final int UNIVERSAL_TAG_VIDEOTEXSTRING = 21;
    public static final int UNIVERSAL_TAG_T61STRING = 20;
    public static final int UNIVERSAL_TAG_PRINTABLESTRING = 19;
    public static final int UNIVERSAL_TAG_NUMERICSTRING = 18;
    public static final int UNIVERSAL_TAG_SETOF = 17;
    public static final int UNIVERSAL_TAG_SET = 17;
    public static final int UNIVERSAL_TAG_SEQUENCEOF = 16;
    public static final int UNIVERSAL_TAG_SEQUENCE = 16;
    public static final int UNIVERSAL_TAG_ENUMERATION = 10;
    public static final int UNIVERSAL_TAG_REAL = 9;
    public static final int UNIVERSAL_TAG_EXTERNAL = 8;
    public static final int UNIVERSAL_TAG_OD = 7;
    public static final int UNIVERSAL_TAG_OBJECTIDENTIFIER = 6;
    public static final int UNIVERSAL_TAG_NULL = 5;
    public static final int UNIVERSAL_TAG_OCTETSTRING = 4;
    public static final int UNIVERSAL_TAG_BITSTRING = 3;
    public static final int UNIVERSAL_TAG_INTEGER = 2;
    public static final int UNIVERSAL_TAG_BOOLEAN = 1;
    public static final int UNIVERSAL_TAG_INVALID = 0;
    public static final int MAX_TAG_NUM_VAL = 0x3FFFFFFF;
    public static final int TAG_CLASS_PRIVATE = 3;
    public static final int TAG_CLASS_CONTEXT = 2;
    public static final int TAG_CLASS_APPLICATION = 1;
    public static final int TAG_CLASS_UNIVERSAL = 0;
    private static final long STRING_TAGS = 243007512L;

    public static int buildTag(int tagClass, int tagNumber) throws FStruException {
        if (tagNumber > 0x3FFFFFFF || tagNumber < 0) {
            throw new FStruException("Tag number is not valid");
        }
        return tagClass << 30 | tagNumber;
    }

    public static int buildUniversalTag(int tagNumber) throws FStruException {
        return Tags.buildTag(0, tagNumber);
    }

    public static int buildContextTag(int tagNumber) throws FStruException {
        return Tags.buildTag(2, tagNumber);
    }

    public static int buildApplicationTag(int tagNumber) throws FStruException {
        return Tags.buildTag(1, tagNumber);
    }

    public static int findTagClass(int tag) {
        return tag >>> 30;
    }

    public static int findTagNumber(int tag) {
        return tag & 0x3FFFFFFF;
    }

    public static boolean assertUniversalStringTag(int tag) {
        if (Tags.findTagClass(tag) != 0) {
            throw new IllegalArgumentException("The tag is not a universal tag");
        }
        if (tag >= 64) {
            return false;
        }
        return (0xE7C0018L & (long)(1 << tag)) != 0L;
    }

    public static String universalTagNumber2String(int universalTag) {
        if (Tags.findTagClass(universalTag) != 0) {
            throw new IllegalArgumentException("The tag is not a universal tag");
        }
        if (universalTag >= UNIVERSAL_TAG_NAMES.length) {
            return Integer.toString(universalTag);
        }
        return UNIVERSAL_TAG_NAMES[universalTag];
    }

    public static String tagClass2String(int tag) {
        return TAG_CLASS_NAMES[Tags.findTagClass(tag)];
    }

    public static String tag2String(int tag) {
        if (Tags.findTagClass(tag) == 0) {
            return String.valueOf(Tags.tagClass2String(tag)) + " " + Tags.universalTagNumber2String(tag);
        }
        return String.valueOf(Tags.tagClass2String(tag)) + " " + Integer.toString(Tags.findTagNumber(tag));
    }
}

