/*
 * Decompiled with CFR 0.152.
 */
package net.commustru.fstru;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import net.commustru.fstru.Constants;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.IDType;
import net.commustru.util.BinaryString;

public class FStruEncoder
extends Encoder
implements Constants {
    private boolean specialTag;
    private int implicitTag;
    private int offset;
    private final SerializeBuf firstSerBuf;
    private final SerializePosTable firstSerPosTbl;
    private SerializePos parentSerPos;
    private SerializeBuf currSerBuf;
    private int currSerBufPos;
    private SerializePosTable currSerPosTbl;
    private SerializePos currSerPos;
    private int currTblIndex;

    public FStruEncoder() {
        this(1024, 64);
    }

    public FStruEncoder(int bufSize, int tblSize) {
        bufSize = Math.max(32, bufSize);
        tblSize = Math.max(16, tblSize);
        this.firstSerBuf = new SerializeBuf(bufSize);
        this.firstSerPosTbl = new SerializePosTable(tblSize);
        ((SerializePosTable)this.firstSerPosTbl).table[0] = new SerializePos();
        this.initialize();
    }

    private void initialize() {
        this.parentSerPos = this.firstSerPosTbl.table[0];
        this.parentSerPos.offset = 0;
        this.parentSerPos.parent = null;
        this.currSerPos = this.parentSerPos;
        this.currSerBuf = this.firstSerBuf;
        this.currSerPosTbl = this.firstSerPosTbl;
        this.currTblIndex = 1;
        this.offset = 0;
        this.currSerBufPos = 0;
        this.specialTag = false;
    }

    private void setNewOffset(int newOffset) {
        int preBufsLenSum;
        if (this.offset > newOffset) {
            this.currSerBuf = this.firstSerBuf;
            this.currSerBufPos = 0;
            preBufsLenSum = 0;
        } else {
            preBufsLenSum = this.offset - this.currSerBufPos;
        }
        while (newOffset > preBufsLenSum + this.currSerBuf.data.length) {
            preBufsLenSum += this.currSerBuf.data.length;
            this.currSerBuf = this.currSerBuf.next;
        }
        this.currSerBufPos = newOffset - preBufsLenSum;
        this.offset = newOffset;
    }

    private int doWriteToOutput(OutputStream outputstream, byte[] data, int dstPos, int newOffSet, int length) throws IOException {
        this.setNewOffset(newOffSet);
        while (length > 0) {
            int bufLen4Write = Math.min(this.currSerBuf.data.length - this.currSerBufPos, length);
            if (outputstream == null) {
                System.arraycopy(this.currSerBuf.data, this.currSerBufPos, data, dstPos, bufLen4Write);
                dstPos += bufLen4Write;
            } else {
                outputstream.write(this.currSerBuf.data, this.currSerBufPos, bufLen4Write);
            }
            this.currSerBufPos += bufLen4Write;
            if (this.currSerBuf.data.length <= this.currSerBufPos) {
                this.currSerBuf = this.currSerBuf.next;
                this.currSerBufPos = 0;
            }
            length -= bufLen4Write;
            this.offset += bufLen4Write;
        }
        return dstPos;
    }

    private int newAdjoiningBytes(int size) {
        int unused = this.currSerBuf.data.length - this.currSerBufPos;
        if (size > unused) {
            this.offset += unused;
            if (this.currSerBuf.next == null) {
                this.currSerBuf.next = new SerializeBuf(this.currSerBuf.data.length);
            }
            this.currSerBuf = this.currSerBuf.next;
            this.currSerBufPos = 0;
        }
        this.currSerBufPos += size;
        this.offset += size;
        return this.offset - size;
    }

    private void appendOctet(int octet) {
        ++this.offset;
        if (this.currSerBufPos >= this.currSerBuf.data.length) {
            if (this.currSerBuf.next == null) {
                this.currSerBuf.next = new SerializeBuf(this.currSerBuf.data.length);
            }
            this.currSerBuf = this.currSerBuf.next;
            this.currSerBufPos = 0;
        }
        ((SerializeBuf)this.currSerBuf).data[this.currSerBufPos] = (byte)octet;
        ++this.currSerBufPos;
    }

    private void appendOctets(byte[] octets, int beginIndex, int length) {
        this.offset += length;
        int unused = this.currSerBuf.data.length - this.currSerBufPos;
        while (length > unused) {
            System.arraycopy(octets, beginIndex, this.currSerBuf.data, this.currSerBufPos, unused);
            length -= unused;
            beginIndex += unused;
            if (this.currSerBuf.next == null) {
                this.currSerBuf.next = new SerializeBuf(this.currSerBuf.data.length);
            }
            this.currSerBuf = this.currSerBuf.next;
            this.currSerBufPos = 0;
            unused = this.currSerBuf.data.length;
        }
        if (length > 0) {
            System.arraycopy(octets, beginIndex, this.currSerBuf.data, this.currSerBufPos, length);
            this.currSerBufPos += length;
        }
    }

    private void newCurrSerPos() {
        if (this.currTblIndex >= this.currSerPosTbl.table.length) {
            if (this.currSerPosTbl.next == null) {
                SerializePosTable encpostable = new SerializePosTable(this.currSerPosTbl.table.length);
                this.currSerPosTbl.next = encpostable;
            }
            this.currSerPosTbl = this.currSerPosTbl.next;
            this.currTblIndex = 0;
        }
        this.currSerPos = this.currSerPosTbl.table[this.currTblIndex];
        if (this.currSerPos == null) {
            SerializePos serializePos = new SerializePos();
            ((SerializePosTable)this.currSerPosTbl).table[this.currTblIndex] = serializePos;
            this.currSerPos = serializePos;
        } else {
            this.currSerPos.reset();
        }
        ++this.currTblIndex;
    }

    private int serializeTag(boolean explicit, int tag) throws FStruException {
        this.parentSerPos.oneMoreChild();
        if (this.currSerPos.length == 0 && this.currSerPos.isPrimitive()) {
            this.currSerPos.length = this.offset - this.currSerPos.offset;
            SerializePos serializePos = this.parentSerPos;
            serializePos.length = serializePos.length + this.currSerPos.length;
        }
        this.newCurrSerPos();
        this.currSerPos.parent = this.parentSerPos;
        this.currSerPos.setTag(tag, this.specialTag ? this.implicitTag : -1);
        if (!explicit) {
            this.currSerPos.offset = this.offset;
            this.currSerPos.setPrimitive();
            if (tag != 0) {
                this.doEncodeTag(false, tag);
            }
        } else {
            this.currSerPos.offset = this.newAdjoiningBytes(10);
            this.specialTag = false;
            this.parentSerPos = this.currSerPos;
        }
        return this.currSerPos.offset;
    }

    private void setEndOfConstructed(int constrouctedOffset) throws FStruException {
        if (this.parentSerPos.offset != constrouctedOffset || this.parentSerPos == this.firstSerPosTbl.table[0]) {
            throw new FStruException("Not expected end of constructed encoding terminations");
        }
        if (this.currSerPos.length == 0 && this.currSerPos.isPrimitive()) {
            this.currSerPos.length = this.offset - this.currSerPos.offset;
            SerializePos serializePos = this.parentSerPos;
            serializePos.length = serializePos.length + this.currSerPos.length;
        }
        SerializeBuf currBufTmp = this.currSerBuf;
        int currBufPosTmp = this.currSerBufPos;
        int offsetTmp = this.offset;
        this.setNewOffset(this.parentSerPos.offset);
        this.doEncodeTag(true, this.parentSerPos.getEncodedTag());
        this.serializeLength(this.parentSerPos.length);
        int tlLen = this.offset - this.parentSerPos.offset;
        this.parentSerPos.setTLLength(tlLen);
        SerializePos serializePos = this.parentSerPos.parent;
        serializePos.length = serializePos.length + (tlLen + this.parentSerPos.length);
        this.parentSerPos = this.parentSerPos.parent;
        this.currSerBuf = currBufTmp;
        this.currSerBufPos = currBufPosTmp;
        this.offset = offsetTmp;
    }

    @Override
    public void finish() throws FStruException {
        if (this.parentSerPos != this.firstSerPosTbl.table[0]) {
            throw new FStruException("Not the finish of constructed encodings");
        }
        if (this.currSerPos.length == 0 && this.currSerPos.isPrimitive()) {
            this.currSerPos.length = this.offset - this.currSerPos.offset;
            SerializePos serializePos = this.parentSerPos;
            serializePos.length = serializePos.length + this.currSerPos.length;
        }
    }

    @Override
    public byte[] toByteArray() throws FStruException {
        try {
            this.finish();
            byte[] data = new byte[this.firstSerPosTbl.table[0].length];
            this.writeTo(null, data, 0);
            return data;
        }
        catch (IOException ioexception) {
            throw new FStruException(ioexception);
        }
    }

    @Override
    public int toByteArray(byte[] data, int beginIndex) throws FStruException {
        try {
            return this.writeTo(null, data, beginIndex) - beginIndex;
        }
        catch (IOException ioexception) {
            throw new FStruException(ioexception);
        }
    }

    @Override
    public int writeTo(OutputStream outputstream) throws FStruException, IOException {
        return this.writeTo(outputstream, null, 0);
    }

    private int writeTo(OutputStream outputstream, byte[] data, int dstPose) throws FStruException, IOException {
        SerializePos encpos;
        this.finish();
        SerializePosTable endEncpostable = this.currSerPosTbl;
        int endTblIndex = this.currTblIndex;
        this.currSerPosTbl = this.firstSerPosTbl;
        while (this.currSerPosTbl != endEncpostable) {
            this.currTblIndex = this.currSerPosTbl == this.firstSerPosTbl ? 1 : 0;
            while (this.currTblIndex < this.currSerPosTbl.table.length) {
                encpos = this.currSerPosTbl.table[this.currTblIndex];
                dstPose = encpos.isPrimitive() ? this.doWriteToOutput(outputstream, data, dstPose, encpos.offset, encpos.length) : this.doWriteToOutput(outputstream, data, dstPose, encpos.offset, encpos.getTLLength());
                ++this.currTblIndex;
            }
            this.currSerPosTbl = this.currSerPosTbl.next;
        }
        this.currTblIndex = 0;
        while (this.currTblIndex < endTblIndex) {
            encpos = this.currSerPosTbl.table[this.currTblIndex];
            dstPose = encpos.isPrimitive() ? this.doWriteToOutput(outputstream, data, dstPose, encpos.offset, encpos.length) : this.doWriteToOutput(outputstream, data, dstPose, encpos.offset, encpos.getTLLength());
            ++this.currTblIndex;
        }
        return dstPose;
    }

    @Override
    public int serializeExplicit(int tag) throws FStruException {
        return this.serializeTag(true, tag);
    }

    @Override
    public int serializeSequence() throws FStruException {
        return this.serializeTag(true, 16);
    }

    @Override
    public int serializeSet() throws FStruException {
        return this.serializeTag(true, 17);
    }

    @Override
    public void finishedBy(int offset) throws FStruException {
        this.setEndOfConstructed(offset);
    }

    @Override
    public void serializeOctetString(byte[] byteArr) throws FStruException {
        this.serializeOctetString(byteArr, 0, byteArr.length);
    }

    @Override
    public void serializeTeletexString(String teletexStr) throws FStruException {
        this.serializeT61String(teletexStr);
    }

    @Override
    public void serializeISO646String(String iso646Str) throws FStruException {
        this.serializeVisibleString(iso646Str);
    }

    @Override
    public void serializeBMPString(String bmpStr) throws FStruException {
        int length = bmpStr.length();
        this.encodeTagAndLength(false, 30, 2 * length);
        int i = 0;
        while (i < length) {
            char bmpChr = bmpStr.charAt(i);
            this.appendOctet(bmpChr >> 8);
            this.appendOctet(bmpChr);
            ++i;
        }
    }

    @Override
    public void serializeBinaryString(BinaryString bitstring) throws FStruException {
        int length = bitstring.length();
        int j = 8 - (length & 7) & 7;
        this.encodeTagAndLength(false, 3, length + 15 >> 3);
        this.appendOctet(j);
        length -= 8;
        while (length >= 0) {
            this.appendOctet(bitstring.convertToInt(length, 8));
            length -= 8;
        }
        if (length != -8) {
            this.appendOctet((byte)(bitstring.convertToInt(0, 8 - j) << j));
        }
    }

    @Override
    public void serializeBoolean(boolean flag) throws FStruException {
        this.encodeTagAndLength(false, 1, 1);
        this.appendOctet(flag ? 255 : 0);
    }

    @Override
    public void serializeChoice(int i, int[] ai) {
    }

    @Override
    public boolean serializeDefault() {
        return true;
    }

    @Override
    public void serializeEnumeration(int value) throws FStruException {
        int valuelen = value >= 0 ? (value >= 0x800000 ? 4 : (value >= 32768 ? 3 : (value >= 128 ? 2 : 1))) : (value < -8388608 ? 4 : (value < Short.MIN_VALUE ? 3 : (value < -128 ? 2 : 1)));
        this.encodeTagAndLength(false, 10, valuelen);
        int i = valuelen;
        while (i > 0) {
            this.appendOctet(value >> (i - 1) * 8);
            --i;
        }
    }

    @Override
    public void serializeGeneralString(String generalStr) throws FStruException {
        this.encodeTagAndLength(false, 27, generalStr.length());
        this.serializeStringValue(generalStr);
    }

    @Override
    public void serializeGeneralizedTime(String generalTime) throws FStruException {
        this.encodeTagAndLength(false, 24, generalTime.length());
        this.serializeStringValue(generalTime);
    }

    @Override
    public void serializeGeneralizedTime(Calendar calendar) throws FStruException {
        int milliSecond = calendar.get(14);
        int milliSecondLen = milliSecond == 0 ? 0 : (milliSecond < 10 ? 2 : (milliSecond < 100 ? 3 : 4));
        int zoneOffset = calendar.get(15) / 1000;
        int zoneOffsetLen = zoneOffset != 0 ? 5 : 1;
        int length = 14 + milliSecondLen + zoneOffsetLen;
        this.encodeTagAndLength(false, 24, length);
        int year = calendar.get(1);
        this.serializeDoubleDecimalDigits(year / 100);
        this.serializeDoubleDecimalDigits(year % 100);
        this.serializeDoubleDecimalDigits(calendar.get(2) + 1);
        this.serializeDoubleDecimalDigits(calendar.get(5));
        this.serializeDoubleDecimalDigits(calendar.get(11));
        this.serializeDoubleDecimalDigits(calendar.get(12));
        this.serializeDoubleDecimalDigits(calendar.get(13));
        if (milliSecond != 0) {
            this.appendOctet(46);
            switch (length) {
                case 19: {
                    this.appendOctet(milliSecond / 100 % 10 + 48);
                }
                case 18: {
                    this.appendOctet(milliSecond / 10 % 10 + 48);
                }
                case 17: {
                    this.appendOctet(milliSecond % 10 + 48);
                }
            }
        }
        if (zoneOffset < 0) {
            this.appendOctet(45);
            this.serializeDoubleDecimalDigits(-zoneOffset / 60);
            this.serializeDoubleDecimalDigits(-zoneOffset % 60);
        } else if (zoneOffset > 0) {
            this.appendOctet(43);
            this.serializeDoubleDecimalDigits(zoneOffset / 60);
            this.serializeDoubleDecimalDigits(zoneOffset % 60);
        } else {
            this.appendOctet(90);
        }
    }

    @Override
    public void serializeGraphicString(String grStr) throws FStruException {
        this.encodeTagAndLength(false, 25, grStr.length());
        this.serializeStringValue(grStr);
    }

    @Override
    public void serializeIA5String(String ia5Str) throws FStruException {
        this.encodeTagAndLength(false, 22, ia5Str.length());
        this.serializeStringValue(ia5Str);
    }

    @Override
    public void serializeInteger(int value) throws FStruException {
        int length = value >= 0 ? (value > 0x7FFFFF ? 4 : (value > Short.MAX_VALUE ? 3 : (value > 127 ? 2 : 1))) : (value < -8388608 ? 4 : (value < Short.MIN_VALUE ? 3 : (value < -128 ? 2 : 1)));
        this.encodeTagAndLength(false, 2, length);
        int i = length;
        while (i > 0) {
            this.appendOctet(value >> (i - 1) * 8);
            --i;
        }
    }

    @Override
    public void serializeInteger(long value) throws FStruException {
        int length = value >= 0L ? (value >= 0x80000000000000L ? 8 : (value >= 0x800000000000L ? 7 : (value >= 0x8000000000L ? 6 : (value >= 0x80000000L ? 5 : (value >= 0x800000L ? 4 : (value >= 32768L ? 3 : (value >= 128L ? 2 : 1))))))) : (value < -36028797018963968L ? 8 : (value < -140737488355328L ? 7 : (value < -549755813888L ? 6 : (value < Integer.MIN_VALUE ? 5 : (value < -8388608L ? 4 : (value < -32768L ? 3 : (value < -128L ? 2 : 1)))))));
        this.encodeTagAndLength(false, 2, length);
        int i = length;
        while (i > 0) {
            this.appendOctet((int)(value >> (i - 1) * 8));
            --i;
        }
    }

    @Override
    public void serializeInteger(BigInteger biginteger) throws FStruException {
        byte[] octets = biginteger.toByteArray();
        this.encodeTagAndLength(false, 2, octets.length);
        this.appendOctets(octets, 0, octets.length);
    }

    @Override
    public void serializeNull() throws FStruException {
        this.encodeTagAndLength(false, 5, 0);
    }

    @Override
    public void serializeNumericString(String numStr) throws FStruException {
        this.encodeTagAndLength(false, 18, numStr.length());
        this.serializeStringValue(numStr);
    }

    @Override
    public void serializeIDType(IDType asn1oid) throws FStruException {
        int component;
        int len = 1;
        int rawLen = asn1oid.level();
        int i = 2;
        while (i < rawLen) {
            component = asn1oid.nthComponent(i);
            len = component >= 0x10000000 ? (len += 5) : (component >= 0x200000 ? (len += 4) : (component >= 16384 ? (len += 3) : (component >= 128 ? (len += 2) : ++len)));
            ++i;
        }
        this.encodeTagAndLength(false, 6, len);
        this.serializeLength(asn1oid.nthComponent(0) * 40 + asn1oid.nthComponent(1));
        i = 2;
        while (i < rawLen) {
            component = asn1oid.nthComponent(i);
            if (component >= 0x10000000) {
                this.appendOctet(component >>> 28 | 0x80);
            }
            if (component >= 0x200000) {
                this.appendOctet(component >>> 21 | 0x80);
            }
            if (component >= 16384) {
                this.appendOctet(component >>> 14 | 0x80);
            }
            if (component >= 128) {
                this.appendOctet(component >>> 7 | 0x80);
            }
            this.appendOctet(component & 0x7F);
            ++i;
        }
    }

    @Override
    public void serializeOctetString(byte[] byteArr, int i, int length) throws FStruException {
        this.encodeTagAndLength(false, 4, length);
        int index = 0;
        while (index < length) {
            this.appendOctet(byteArr[index]);
            ++index;
        }
    }

    @Override
    public void serializePrintableString(String printableStr) throws FStruException {
        this.encodeTagAndLength(false, 19, printableStr.length());
        this.serializeStringValue(printableStr);
    }

    @Override
    public void serializeDouble(double value) throws FStruException {
        throw new FStruException("Double type serializing not yet implemented");
    }

    @Override
    public int serializeSequenceOf() throws FStruException {
        return this.serializeSequence();
    }

    @Override
    public int serializeSetOf() throws FStruException {
        return this.serializeSet();
    }

    @Override
    public void serializeT61String(String t61Str) throws FStruException {
        this.encodeTagAndLength(false, 20, t61Str.length());
        this.serializeStringValue(t61Str);
    }

    @Override
    public void serializeUTCTime(String utcTime) throws FStruException {
        this.encodeTagAndLength(false, 23, utcTime.length());
        this.serializeStringValue(utcTime);
    }

    @Override
    public void serializeUTCTime(Calendar utcTime) throws FStruException {
        int zoneOffset = utcTime.get(15) / 1000;
        if (zoneOffset == 0) {
            this.encodeTagAndLength(false, 23, 13);
        } else {
            this.encodeTagAndLength(false, 23, 17);
        }
        int year = utcTime.get(1);
        this.serializeDoubleDecimalDigits(year >= 2000 ? year - 2000 : year - 1900);
        this.serializeDoubleDecimalDigits(utcTime.get(2) + 1);
        this.serializeDoubleDecimalDigits(utcTime.get(5));
        this.serializeDoubleDecimalDigits(utcTime.get(11));
        this.serializeDoubleDecimalDigits(utcTime.get(12));
        this.serializeDoubleDecimalDigits(utcTime.get(13));
        if (zoneOffset < 0) {
            this.appendOctet(45);
            this.serializeDoubleDecimalDigits(-zoneOffset / 60);
            this.serializeDoubleDecimalDigits(-zoneOffset % 60);
        } else if (zoneOffset > 0) {
            this.appendOctet(43);
            this.serializeDoubleDecimalDigits(zoneOffset / 60);
            this.serializeDoubleDecimalDigits(zoneOffset % 60);
        } else {
            this.appendOctet(90);
        }
    }

    @Override
    public void serializeVideotexString(String vidoStr) throws FStruException {
        this.encodeTagAndLength(false, 21, vidoStr.length());
        this.serializeStringValue(vidoStr);
    }

    @Override
    public void serializeVisibleString(String visiStr) throws FStruException {
        this.encodeTagAndLength(false, 26, visiStr.length());
        this.serializeStringValue(visiStr);
    }

    @Override
    public void setNextImplicit(int tag) {
        this.specialTag = true;
        this.implicitTag = tag;
    }

    private void encodeTagAndLength(boolean explicit, int tag, int length) throws FStruException {
        this.serializeTag(explicit, tag);
        this.serializeLength(length);
    }

    private void doEncodeTag(boolean explicit, int tag) throws FStruException {
        if (this.specialTag) {
            tag = this.implicitTag;
            this.specialTag = false;
        }
        int tagNumber = FStruEncoder.findTagNumber(tag);
        int tagClass = explicit ? 32 : 0;
        switch (FStruEncoder.findTagClass(tag)) {
            case 0: {
                tagClass |= 0;
                break;
            }
            case 1: {
                tagClass |= 0x40;
                break;
            }
            case 2: {
                tagClass |= 0x80;
                break;
            }
            case 3: {
                tagClass |= 0xC0;
            }
        }
        if (tagNumber <= 30) {
            this.appendOctet(tagClass | tagNumber);
        } else {
            this.appendOctet(tagClass | 0x1F);
            if (tagNumber > 0xFFFFFFF) {
                this.appendOctet(tagNumber >>> 28 | 0x80);
            }
            if (tagNumber > 0x1FFFFF) {
                this.appendOctet(tagNumber >>> 21 | 0x80);
            }
            if (tagNumber > 16383) {
                this.appendOctet(tagNumber >>> 14 | 0x80);
            }
            if (tagNumber > 127) {
                this.appendOctet(tagNumber >>> 7 | 0x80);
            }
            this.appendOctet(tagNumber & 0x7F);
        }
    }

    private void serializeLength(int length) throws FStruException {
        if (length >= 128) {
            int lenOfLen = length >= 0x1000000 ? 4 : (length >= 65536 ? 3 : (length >= 256 ? 2 : 1));
            this.appendOctet(0x80 | lenOfLen);
            int i = lenOfLen;
            while (i > 0) {
                this.appendOctet(length >> (i - 1) * 8);
                --i;
            }
            return;
        }
        this.appendOctet(length);
    }

    private void serializeStringValue(String s) throws FStruException {
        int i = 0;
        int j = s.length();
        while (i < j) {
            this.appendOctet(s.charAt(i));
            ++i;
        }
    }

    private final void serializeDoubleDecimalDigits(int i) throws FStruException {
        this.appendOctet(i / 10 % 10 + 48);
        this.appendOctet(i % 10 + 48);
    }

    private static final class SerializeBuf {
        private final byte[] data;
        private SerializeBuf next = null;

        private SerializeBuf(int buffSize) {
            this.data = new byte[buffSize];
        }
    }

    private static class SerializePos {
        private int info;
        private int tag;
        private int implicitTag;
        private int length;
        private int offset;
        private SerializePos parent;

        private SerializePos() {
        }

        private final int oneMoreChild() {
            return this.info += 16;
        }

        private final boolean isPrimitive() {
            return this.info == -1;
        }

        private final void setPrimitive() {
            this.info = -1;
        }

        private final int getTLLength() {
            return this.info & 0xF;
        }

        private final void setTLLength(int i) {
            this.info += i;
        }

        private final int getEncodedTag() {
            if (this.implicitTag == -1) {
                return this.tag;
            }
            return this.implicitTag;
        }

        private final void setTag(int _tag, int _implicitTag) {
            this.tag = _tag;
            this.implicitTag = _implicitTag;
        }

        private final void reset() {
            this.info = 0;
            this.tag = 0;
            this.implicitTag = 0;
            this.length = 0;
            this.offset = 0;
            this.parent = null;
        }
    }

    private static final class SerializePosTable {
        private final SerializePos[] table;
        private SerializePosTable next;

        private SerializePosTable(int size) {
            this.table = new SerializePos[size];
        }
    }
}

