/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XContainer;
import bibliothek.util.xml.XException;
import bibliothek.util.xml.XIO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XElement
extends XContainer
implements Iterable<XElement> {
    private List<XAttribute> attributes = new ArrayList<XAttribute>();
    private List<XElement> children = new ArrayList<XElement>();
    private String name;

    public XElement(String string) {
        this.setName(string);
    }

    @Override
    public XElement copy() {
        XElement xElement = new XElement(this.name);
        xElement.copy(this);
        return xElement;
    }

    public void copy(XElement xElement) {
        super.copy(xElement);
        this.attributes.clear();
        for (XAttribute xContainer : xElement.attributes) {
            this.attributes.add(xContainer.copy());
        }
        this.children.clear();
        for (XElement xElement2 : xElement.children) {
            this.children.add(xElement2.copy());
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<XElement> iterator() {
        return this.children.iterator();
    }

    public XAttribute[] attributes() {
        return this.attributes.toArray(new XAttribute[this.attributes.size()]);
    }

    public XElement[] children() {
        return this.children.toArray(new XElement[this.children.size()]);
    }

    public XElement addAttribute(XAttribute xAttribute) {
        if (xAttribute == null) {
            throw new NullPointerException("attribute must not be null");
        }
        this.attributes.add(xAttribute);
        return this;
    }

    public XElement addByte(String string, byte by) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setByte(by);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addShort(String string, short s) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setShort(s);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addInt(String string, int n) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setInt(n);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addLong(String string, long l) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setLong(l);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addFloat(String string, float f) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setFloat(f);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addDouble(String string, double d) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setDouble(d);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addChar(String string, char c) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setChar(c);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addString(String string, String string2) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setString(string2);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addBoolean(String string, boolean bl) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setBoolean(bl);
        this.addAttribute(xAttribute);
        return this;
    }

    public XElement addByteArray(String string, byte[] byArray) {
        XAttribute xAttribute = new XAttribute(string);
        xAttribute.setByteArray(byArray);
        this.addAttribute(xAttribute);
        return this;
    }

    public boolean attributeExists(String string) {
        return this.getAttribute(string) != null;
    }

    public XAttribute getAttribute(String string) {
        for (XAttribute xAttribute : this.attributes) {
            if (!xAttribute.getName().equals(string)) continue;
            return xAttribute;
        }
        return null;
    }

    public byte getByte(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getByte();
    }

    public short getShort(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getShort();
    }

    public int getInt(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getInt();
    }

    public long getLong(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getLong();
    }

    public float getFloat(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getFloat();
    }

    public double getDouble(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getDouble();
    }

    public char getChar(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getChar();
    }

    public String getString(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getString();
    }

    public boolean getBoolean(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getBoolean();
    }

    public byte[] getByteArray(String string) {
        XAttribute xAttribute = this.getAttribute(string);
        if (xAttribute == null) {
            throw new XException("no attribute known with name: " + string);
        }
        return xAttribute.getByteArray();
    }

    public void addElement(XElement xElement) {
        if (xElement == null) {
            throw new NullPointerException("element must not be null");
        }
        this.children.add(xElement);
    }

    public XElement addElement(String string) {
        XElement xElement = new XElement(string);
        this.addElement(xElement);
        return xElement;
    }

    public XElement getElement(String string) {
        for (XElement xElement : this.children) {
            if (!xElement.getName().equals(string)) continue;
            return xElement;
        }
        return null;
    }

    public int getElementCount() {
        return this.children.size();
    }

    public XElement getElement(int n) {
        return this.children.get(n);
    }

    public XElement[] getElements(String string) {
        LinkedList<XElement> linkedList = new LinkedList<XElement>();
        for (XElement xElement : this.children) {
            if (!xElement.getName().equals(string)) continue;
            linkedList.add(xElement);
        }
        return linkedList.toArray(new XElement[linkedList.size()]);
    }

    @Override
    public void setString(String string) {
        if (string.length() == 0) {
            string = "[]";
        } else if (Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(string.length() - 1))) {
            string = "[" + string + "]";
        } else if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = "[" + string + "]";
        }
        super.setString(string);
    }

    @Override
    public String getString() {
        String string = super.getString();
        if (string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            XIO.write(this, stringBuilder);
        }
        catch (IOException iOException) {
            throw new XException(iOException);
        }
        return stringBuilder.toString();
    }
}

