/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockUtilities {
    public static void visit(Dockable dockable, DockVisitor dockVisitor) {
        DockUtilities.visitDockable(dockable, dockVisitor);
    }

    public static void visit(DockStation dockStation, DockVisitor dockVisitor) {
        Dockable dockable = dockStation.asDockable();
        if (dockable != null) {
            DockUtilities.visitDockable(dockable, dockVisitor);
        } else {
            DockUtilities.visitStation(dockStation, dockVisitor);
        }
    }

    public static void visit(DockElement dockElement, DockVisitor dockVisitor) {
        Dockable dockable = dockElement.asDockable();
        if (dockable != null) {
            DockUtilities.visitDockable(dockable, dockVisitor);
        } else {
            DockStation dockStation = dockElement.asDockStation();
            if (dockStation != null) {
                DockUtilities.visitStation(dockStation, dockVisitor);
            }
        }
    }

    private static void visitDockable(Dockable dockable, DockVisitor dockVisitor) {
        dockVisitor.handleDockable(dockable);
        DockStation dockStation = dockable.asDockStation();
        if (dockStation != null) {
            DockUtilities.visitStation(dockStation, dockVisitor);
        }
    }

    private static void visitStation(DockStation dockStation, DockVisitor dockVisitor) {
        dockVisitor.handleDockStation(dockStation);
        int n = dockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            DockUtilities.visitDockable(dockStation.getDockable(i), dockVisitor);
        }
    }

    public static List<Dockable> listDockables(final DockElement dockElement, final boolean bl) {
        final ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
        DockUtilities.visit(dockElement, new DockVisitor(){

            public void handleDockable(Dockable dockable) {
                if (bl || dockable != dockElement) {
                    arrayList.add(dockable);
                }
            }
        });
        return arrayList;
    }

    public static boolean isAncestor(DockElement dockElement, DockElement dockElement2) {
        if (dockElement == null) {
            throw new NullPointerException("ancestor must not be null");
        }
        if (dockElement2 == null) {
            throw new NullPointerException("child must not be null");
        }
        Dockable dockable = dockElement2.asDockable();
        DockStation dockStation = null;
        while (dockable != null) {
            if (dockElement == dockable) {
                return true;
            }
            dockStation = dockable.getDockParent();
            dockable = dockStation == null ? null : dockStation.asDockable();
        }
        return dockStation == dockElement;
    }

    public static DockStation getRoot(DockElement dockElement) {
        Dockable dockable = dockElement.asDockable();
        if (dockable == null) {
            return dockElement.asDockStation();
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return dockElement.asDockStation();
        }
        while ((dockable = dockStation.asDockable()) != null && dockable.getDockParent() != null) {
            dockStation = dockable.getDockParent();
        }
        return dockStation;
    }

    public static DockableProperty append(DockableProperty dockableProperty, DockableProperty dockableProperty2) {
        if (dockableProperty == null) {
            return dockableProperty2;
        }
        dockableProperty = dockableProperty.copy();
        DockUtilities.getLastProperty(dockableProperty).setSuccessor(dockableProperty2);
        return dockableProperty;
    }

    public static DockableProperty getLastProperty(DockableProperty dockableProperty) {
        while (dockableProperty.getSuccessor() != null) {
            dockableProperty = dockableProperty.getSuccessor();
        }
        return dockableProperty;
    }

    public static DockableProperty getPropertyChain(Dockable dockable) {
        DockStation dockStation = DockUtilities.getRoot(dockable);
        if (dockStation == null || dockStation == dockable) {
            return null;
        }
        return DockUtilities.getPropertyChain(dockStation, dockable);
    }

    public static DockableProperty getPropertyChain(DockStation dockStation, Dockable dockable) {
        if (dockStation == dockable) {
            throw new IllegalArgumentException("ground and dockable are the same");
        }
        DockStation dockStation2 = dockable.getDockParent();
        DockableProperty dockableProperty = dockStation2.getDockableProperty(dockable);
        while (dockStation2 != dockStation) {
            dockable = dockStation2.asDockable();
            if (dockable == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            dockStation2 = dockable.getDockParent();
            if (dockStation2 == null) {
                throw new IllegalArgumentException("The chain is not complete");
            }
            DockableProperty dockableProperty2 = dockStation2.getDockableProperty(dockable);
            dockableProperty2.setSuccessor(dockableProperty);
            dockableProperty = dockableProperty2;
        }
        return dockableProperty;
    }

    public static Component getShowingComponent(Dockable dockable) {
        Component component = dockable.getComponent();
        if (!component.isShowing()) {
            DockTitle dockTitle;
            DockTitle[] dockTitleArray = dockable.listBoundTitles();
            int n = dockTitleArray.length;
            for (int i = 0; i < n && !(component = (dockTitle = dockTitleArray[i]).getComponent()).isShowing(); ++i) {
            }
        }
        if (component.isShowing()) {
            return component;
        }
        return null;
    }

    public static void ensureTreeValidity(DockStation dockStation, Dockable dockable) {
        if (dockStation == null) {
            throw new NullPointerException("parent must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("child must not be null");
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockable == dockStation) {
            throw new IllegalArgumentException("child and parent are the same");
        }
        if (DockUtilities.isAncestor(dockable, dockStation)) {
            if (dockable.getDockParent() == dockStation) {
                dockStation.drag(dockable);
            } else {
                throw new IllegalArgumentException("can't create a cycle");
            }
        }
        if (dockStation2 != null) {
            if (dockStation2 != dockStation && !dockStation2.canDrag(dockable)) {
                throw new IllegalStateException("old parent of child does not want do release the child");
            }
            dockStation2.drag(dockable);
        }
    }

    public static Icon disabledIcon(JComponent jComponent, Icon icon) {
        if (icon == null) {
            return null;
        }
        Icon icon2 = UIManager.getLookAndFeel().getDisabledIcon(jComponent, icon);
        if (icon2 != null) {
            return icon2;
        }
        if (jComponent != null) {
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            icon.paintIcon(jComponent, graphics2D, 0, 0);
            graphics2D.dispose();
            icon = new ImageIcon(bufferedImage);
            icon2 = UIManager.getLookAndFeel().getDisabledIcon(jComponent, icon);
        }
        if (icon2 != null) {
            return icon2;
        }
        return icon;
    }

    public static Image iconImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public static Map<String, Icon> loadIcons(String string, String string2, ClassLoader classLoader) {
        try {
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                return new HashMap<String, Icon>();
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            HashMap<String, Icon> hashMap = new HashMap<String, Icon>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                URL uRL;
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if (string2 != null) {
                    string4 = string2 + string4;
                }
                if ((uRL = classLoader.getResource(string4)) == null) {
                    System.err.println("Missing file: " + string4);
                    continue;
                }
                ImageIcon imageIcon = new ImageIcon(uRL);
                hashMap.put(string3, imageIcon);
            }
            return hashMap;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new HashMap<String, Icon>();
        }
    }

    public static void exchangeTitle(DockableDisplayer dockableDisplayer, DockTitleVersion dockTitleVersion) {
        Dockable dockable = dockableDisplayer.getDockable();
        if (dockable == null) {
            throw new IllegalArgumentException("Missing dockable for displayer");
        }
        DockTitle dockTitle = dockableDisplayer.getTitle();
        if (dockTitle != null) {
            dockable.unbind(dockTitle);
        }
        if (dockTitleVersion != null) {
            dockTitle = dockable.getDockTitle(dockTitleVersion);
            if (dockTitle != null) {
                dockable.bind(dockTitle);
            }
        } else {
            dockTitle = null;
        }
        dockableDisplayer.setTitle(dockTitle);
    }

    public static abstract class DockVisitor {
        public void handleDockable(Dockable dockable) {
        }

        public void handleDockStation(DockStation dockStation) {
        }
    }
}

