/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.PropertyKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockProperties {
    private Map<PropertyKey<?>, Entry<?>> map = new HashMap();

    public <A> void set(PropertyKey<A> propertyKey, A a) {
        Entry<A> entry = this.getEntry(propertyKey, true);
        entry.setValue(a);
        entry.setHasBeenSet(true);
        this.check(entry);
    }

    public <A> void setOrRemove(PropertyKey<A> propertyKey, A a) {
        if (a == null) {
            this.toDefault(propertyKey);
        } else {
            this.set(propertyKey, a);
        }
    }

    public void toDefault(PropertyKey<?> propertyKey) {
        Entry<?> entry = this.getEntry(propertyKey, true);
        entry.setHasBeenSet(false);
        entry.setValue(null);
        this.check(entry);
    }

    public <A> A get(PropertyKey<A> propertyKey) {
        Entry<A> entry = this.getEntry(propertyKey, true);
        return entry.getValue();
    }

    public <A> boolean isSet(PropertyKey<A> propertyKey) {
        Entry<A> entry = this.getEntry(propertyKey, false);
        if (entry == null) {
            return false;
        }
        if (!entry.hasBeenSet()) {
            return false;
        }
        if (((Entry)entry).value != null) {
            return true;
        }
        return !propertyKey.isNullValueReplacedByDefault();
    }

    public <A> void addListener(PropertyKey<A> propertyKey, DockPropertyListener<A> dockPropertyListener) {
        if (dockPropertyListener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.getEntry(propertyKey, true).addListener(dockPropertyListener);
    }

    public <A> void removeListener(PropertyKey<A> propertyKey, DockPropertyListener<A> dockPropertyListener) {
        Entry<A> entry = this.getEntry(propertyKey, false);
        if (entry != null) {
            entry.removeListener(dockPropertyListener);
            this.check(entry);
        }
    }

    private <A> Entry<A> getEntry(PropertyKey<A> propertyKey, boolean bl) {
        Entry<Object> entry = this.map.get(propertyKey);
        if (entry == null && bl) {
            entry = new Entry<A>(propertyKey);
            this.map.put(propertyKey, entry);
        }
        return entry;
    }

    private void check(Entry<?> entry) {
        if (entry.removeable()) {
            this.map.remove(entry.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry<A> {
        private PropertyKey<A> key;
        private List<DockPropertyListener<A>> listeners = new ArrayList<DockPropertyListener<A>>();
        private A value;
        private boolean hasBeenSet = false;
        private A defaultValue;
        private boolean defaultValueSet = false;

        public Entry(PropertyKey<A> propertyKey) {
            this.key = propertyKey;
        }

        public void setValue(A a) {
            A a2 = this.getValue();
            this.value = a;
            A a3 = this.getValue();
            if (a2 == null && a3 != null || a2 != null && a3 == null || a2 != null && !a2.equals(a3)) {
                for (DockPropertyListener dockPropertyListener : this.listeners.toArray(new DockPropertyListener[this.listeners.size()])) {
                    dockPropertyListener.propertyChanged(DockProperties.this, this.key, a2, a3);
                }
            }
        }

        public A getValue() {
            if (this.value == null) {
                if (this.hasBeenSet && !this.key.isNullValueReplacedByDefault()) {
                    return null;
                }
                return this.getDefault();
            }
            return this.value;
        }

        public A getDefault() {
            if (!this.defaultValueSet) {
                this.defaultValue = this.key.getDefault(DockProperties.this);
                this.defaultValueSet = true;
            }
            return this.defaultValue;
        }

        public void setHasBeenSet(boolean bl) {
            A a = this.getValue();
            this.hasBeenSet = bl;
            A a2 = this.getValue();
            if (a == null && a2 != null || a != null && a2 == null || a != null && !a.equals(a2)) {
                for (DockPropertyListener dockPropertyListener : this.listeners.toArray(new DockPropertyListener[this.listeners.size()])) {
                    dockPropertyListener.propertyChanged(DockProperties.this, this.key, a, a2);
                }
            }
        }

        public boolean hasBeenSet() {
            return this.hasBeenSet;
        }

        public PropertyKey<A> getKey() {
            return this.key;
        }

        public void addListener(DockPropertyListener<A> dockPropertyListener) {
            this.listeners.add(dockPropertyListener);
        }

        public void removeListener(DockPropertyListener<A> dockPropertyListener) {
            this.listeners.remove(dockPropertyListener);
        }

        public boolean removeable() {
            if (!this.listeners.isEmpty()) {
                return false;
            }
            if (this.value != null) {
                return false;
            }
            return !this.defaultValueSet && !this.hasBeenSet;
        }
    }
}

