/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockTitleVersion {
    private DockTitleFactory[] factories = new DockTitleFactory[3];
    private String id;
    private DockController controller;

    public DockTitleVersion(DockController dockController, String string) {
        if (dockController == null) {
            throw new NullPointerException("Controller must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("The ID must not be null");
        }
        this.controller = dockController;
        this.id = string;
    }

    private int map(Priority priority) {
        switch (priority) {
            case CLIENT: {
                return 0;
            }
            case THEME: {
                return 1;
            }
        }
        return 2;
    }

    public DockTitleFactory getFactory() {
        for (int i = 0; i < this.factories.length; ++i) {
            if (this.factories[i] == null) continue;
            return this.factories[i];
        }
        return this.controller.getTheme().getTitleFactory(this.controller);
    }

    public void setFactory(DockTitleFactory dockTitleFactory, Priority priority) {
        this.factories[this.map((Priority)priority)] = dockTitleFactory;
    }

    public DockTitleFactory getFactory(Priority priority) {
        return this.factories[this.map(priority)];
    }

    public boolean isSet(Priority priority) {
        return this.factories[this.map(priority)] != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DockTitleVersion && ((DockTitleVersion)object).id.equals(this.id);
    }

    public String getID() {
        return this.id;
    }

    public DockTitle createDockable(Dockable dockable) {
        DockTitleFactory dockTitleFactory = this.getFactory();
        if (dockTitleFactory == null) {
            return null;
        }
        return dockTitleFactory.createDockableTitle(dockable, this);
    }

    public <D extends Dockable & DockStation> DockTitle createStation(D d) {
        DockTitleFactory dockTitleFactory = this.getFactory();
        if (dockTitleFactory == null) {
            return null;
        }
        return dockTitleFactory.createStationTitle(d, this);
    }

    public DockController getController() {
        return this.controller;
    }
}

