/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.color;

import bibliothek.extension.gui.dock.util.Path;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.color.ColorManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class DefaultColorScheme
implements ColorScheme {
    private Map<String, Color> colors = new HashMap<String, Color>();
    private Map<Path, ColorBridgeFactory> bridges = new HashMap<Path, ColorBridgeFactory>();

    public boolean updateUI() {
        return false;
    }

    public void setColor(String string, Color color) {
        if (color == null) {
            this.colors.remove(string);
        } else {
            this.colors.put(string, color);
        }
    }

    public void setBridgeFactory(Path path, ColorBridgeFactory colorBridgeFactory) {
        if (colorBridgeFactory == null) {
            this.bridges.remove(path);
        } else {
            this.bridges.put(path, colorBridgeFactory);
        }
    }

    public Color getColor(String string) {
        Color color = this.colors.get(string);
        if (color != null) {
            return color;
        }
        int n = -1;
        for (Map.Entry<String, Color> entry : this.colors.entrySet()) {
            if (!string.startsWith(entry.getKey()) || entry.getKey().length() <= n) continue;
            n = entry.getKey().length();
            color = entry.getValue();
        }
        return color;
    }

    public ColorBridgeFactory getBridgeFactory(Path path) {
        while (path != null) {
            ColorBridgeFactory colorBridgeFactory = this.bridges.get(path);
            if (colorBridgeFactory != null) {
                return colorBridgeFactory;
            }
            path = path.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitAll(Priority priority, ColorManager colorManager) {
        try {
            colorManager.lockUpdate();
            for (Map.Entry<String, Color> entry : this.colors.entrySet()) {
                colorManager.put(priority, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : this.bridges.entrySet()) {
                colorManager.publish(priority, (Path)entry.getKey(), ((ColorBridgeFactory)entry.getValue()).create(colorManager));
            }
        }
        finally {
            colorManager.unlockUpdate();
        }
    }
}

