/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.view.ViewItem;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.menu.AbstractMenuHandler;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuMenuHandler
extends AbstractMenuHandler<JMenu, MenuDockAction> {
    private DockActionSource source;
    private Menu menu;
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private Listener listener = new Listener();

    public MenuMenuHandler(MenuDockAction menuDockAction, Dockable dockable) {
        super(menuDockAction, dockable, new JMenu());
        this.setup(menuDockAction.getMenu(dockable), new JMenuWrapper((JMenu)this.item));
    }

    public MenuMenuHandler(DockActionSource dockActionSource, Dockable dockable, JPopupMenu jPopupMenu) {
        super(null, dockable, null);
        this.setup(dockActionSource, new JPopupMenuWrapper(jPopupMenu));
    }

    private void setup(DockActionSource dockActionSource, Menu menu) {
        this.source = dockActionSource;
        this.menu = menu;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
    }

    @Override
    public void bind() {
        super.bind();
        this.source.addDockActionSourceListener(this.listener);
        int n = this.source.getDockActionCount();
        for (int i = 0; i < n; ++i) {
            DockAction dockAction = this.source.getDockAction(i);
            ActionItem actionItem = new ActionItem();
            actionItem.action = dockAction;
            this.actions.add(actionItem);
            ViewItem<JComponent> viewItem = this.handlerFor(dockAction);
            if (viewItem == null) continue;
            actionItem.handler = viewItem;
            actionItem.action.bind(this.dockable);
            viewItem.bind();
            this.menu.add(viewItem.getItem());
        }
    }

    private ViewItem<JComponent> handlerFor(DockAction dockAction) {
        Dockable dockable = this.getDockable();
        return dockable.getController().getActionViewConverter().createView(dockAction, ViewTarget.MENU, dockable);
    }

    @Override
    public void unbind() {
        super.unbind();
        this.source.removeDockActionSourceListener(this.listener);
        this.menu.removeAll();
        for (ActionItem actionItem : this.actions) {
            if (actionItem.handler == null) continue;
            actionItem.handler.unbind();
            actionItem.action.unbind(this.dockable);
        }
        this.actions.clear();
    }

    private static class JPopupMenuWrapper
    implements Menu {
        private JPopupMenu menu;

        public JPopupMenuWrapper(JPopupMenu jPopupMenu) {
            this.menu = jPopupMenu;
        }

        public void add(JComponent jComponent) {
            this.menu.add(jComponent);
        }

        public JMenuItem getItem() {
            return null;
        }

        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private static class JMenuWrapper
    implements Menu {
        private JMenu menu;

        public JMenuWrapper(JMenu jMenu) {
            this.menu = jMenu;
        }

        public void add(JComponent jComponent) {
            this.menu.add(jComponent);
        }

        public JMenuItem getItem() {
            return this.menu;
        }

        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private static interface Menu {
        public void add(JComponent var1);

        public void removeAll();

        public JMenuItem getItem();
    }

    private static class ActionItem {
        public DockAction action;
        public ViewItem<JComponent> handler;

        private ActionItem() {
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        private void reput() {
            MenuMenuHandler.this.menu.removeAll();
            for (ActionItem actionItem : MenuMenuHandler.this.actions) {
                if (actionItem.handler == null) continue;
                MenuMenuHandler.this.menu.add(actionItem.handler.getItem());
            }
        }

        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                DockAction dockAction = dockActionSource.getDockAction(i);
                ActionItem actionItem = new ActionItem();
                actionItem.action = dockAction;
                MenuMenuHandler.this.actions.add(i, actionItem);
                ViewItem viewItem = MenuMenuHandler.this.handlerFor(dockAction);
                if (viewItem == null) continue;
                dockAction.bind(MenuMenuHandler.this.dockable);
                viewItem.bind();
                actionItem.handler = viewItem;
            }
            this.reput();
        }

        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n2; i >= n; --i) {
                ActionItem actionItem = (ActionItem)MenuMenuHandler.this.actions.remove(i);
                if (actionItem.handler == null) continue;
                actionItem.handler.unbind();
                actionItem.action.unbind(MenuMenuHandler.this.dockable);
            }
        }
    }
}

