/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.container.Triple;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicButtonModel {
    private boolean selected = false;
    private Icon icon;
    private Icon iconSelected;
    private Icon iconDisabled;
    private Icon iconSelectedDisabled;
    private Icon autoIconDisabled;
    private Icon autoIconSelectedDisabled;
    private boolean mouseInside = false;
    private boolean mousePressed = false;
    private JComponent owner;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private BasicTrigger trigger;

    public BasicButtonModel(JComponent jComponent, BasicTrigger basicTrigger) {
        this(jComponent, basicTrigger, true);
    }

    public BasicButtonModel(JComponent jComponent, BasicTrigger basicTrigger, boolean bl) {
        Object object;
        this.owner = jComponent;
        this.trigger = basicTrigger;
        if (bl) {
            object = new Listener();
            jComponent.addMouseListener((MouseListener)object);
            jComponent.addMouseMotionListener((MouseMotionListener)object);
        }
        if ((object = this.listActions()) != null) {
            InputMap inputMap = jComponent.getInputMap();
            ActionMap actionMap = jComponent.getActionMap();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Triple triple = (Triple)iterator.next();
                inputMap.put((KeyStroke)triple.getA(), triple.getB());
                actionMap.put(triple.getB(), (Action)triple.getC());
            }
            jComponent.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    BasicButtonModel.this.setMousePressed(false);
                }
            });
        }
    }

    protected List<Triple<KeyStroke, String, Action>> listActions() {
        ArrayList<Triple<KeyStroke, String, Action>> arrayList = new ArrayList<Triple<KeyStroke, String, Action>>();
        Triple<KeyStroke, String, 2> triple = new Triple<KeyStroke, String, 2>();
        triple.setA(KeyStroke.getKeyStroke(32, 0, false));
        triple.setB("button_model_select");
        triple.setC(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicButtonModel.this.setMousePressed(true);
            }
        });
        arrayList.add(triple);
        Triple<KeyStroke, String, 3> triple2 = new Triple<KeyStroke, String, 3>();
        triple2.setA(KeyStroke.getKeyStroke(32, 0, true));
        triple2.setB("button_model_trigger");
        triple2.setC(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BasicButtonModel.this.mousePressed) {
                    BasicButtonModel.this.setMousePressed(false);
                    if (this.isEnabled()) {
                        BasicButtonModel.this.trigger();
                    }
                }
            }
        });
        arrayList.add(triple2);
        return arrayList;
    }

    public JComponent getOwner() {
        return this.owner;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.autoIconDisabled = null;
        this.changed();
    }

    public void setSelectedIcon(Icon icon) {
        this.iconSelected = icon;
        this.autoIconSelectedDisabled = null;
        this.changed();
    }

    public void setDisabledIcon(Icon icon) {
        this.iconDisabled = icon;
        this.autoIconDisabled = null;
        this.changed();
    }

    public void setSelectedDisabledIcon(Icon icon) {
        this.iconSelectedDisabled = icon;
        this.autoIconSelectedDisabled = null;
        this.changed();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.changed();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setEnabled(boolean bl) {
        this.owner.setEnabled(bl);
        if (!bl) {
            this.setMousePressed(false);
        } else {
            this.changed();
        }
    }

    public boolean isEnabled() {
        return this.owner.isEnabled();
    }

    public void setToolTipText(String string) {
        this.owner.setToolTipText(string);
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Orientation must not be null");
        }
        this.orientation = orientation;
        this.changed();
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void changed() {
        this.owner.repaint();
    }

    public Dimension getMaxIconSize() {
        int n = 0;
        int n2 = 0;
        if (this.icon != null) {
            n = Math.max(n, this.icon.getIconWidth());
            n2 = Math.max(n2, this.icon.getIconHeight());
        }
        if (this.iconSelected != null) {
            n = Math.max(n, this.iconSelected.getIconWidth());
            n2 = Math.max(n2, this.iconSelected.getIconHeight());
        }
        if (this.iconDisabled != null) {
            n = Math.max(n, this.iconDisabled.getIconWidth());
            n2 = Math.max(n2, this.iconDisabled.getIconHeight());
        }
        if (this.iconSelectedDisabled != null) {
            n = Math.max(n, this.iconSelectedDisabled.getIconWidth());
            n2 = Math.max(n2, this.iconSelectedDisabled.getIconHeight());
        }
        return new Dimension(n, n2);
    }

    public Icon getPaintIcon() {
        return this.getPaintIcon(this.isEnabled());
    }

    public Icon getPaintIcon(boolean bl) {
        if (bl) {
            if (this.isSelected() && this.iconSelected != null) {
                return this.iconSelected;
            }
            return this.icon;
        }
        if (this.isSelected()) {
            if (this.iconSelectedDisabled != null) {
                return this.iconSelectedDisabled;
            }
            if (this.iconSelected != null) {
                this.autoIconSelectedDisabled = DockUtilities.disabledIcon(this.owner, this.iconSelected);
            }
            if (this.autoIconSelectedDisabled != null) {
                return this.autoIconSelectedDisabled;
            }
        }
        if (this.iconDisabled != null) {
            return this.iconDisabled;
        }
        if (this.icon != null) {
            this.autoIconDisabled = DockUtilities.disabledIcon(this.owner, this.icon);
        }
        if (this.autoIconDisabled != null) {
            return this.autoIconDisabled;
        }
        return null;
    }

    protected void setMouseInside(boolean bl) {
        this.mouseInside = bl;
        this.changed();
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    protected void setMousePressed(boolean bl) {
        this.mousePressed = bl;
        this.changed();
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    protected void trigger() {
        this.trigger.triggered();
    }

    private class Listener
    extends MouseInputAdapter {
        private Listener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicButtonModel.this.setMouseInside(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicButtonModel.this.setMouseInside(false);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl = BasicButtonModel.this.owner.contains(mouseEvent.getX(), mouseEvent.getY());
            if (bl != BasicButtonModel.this.mouseInside) {
                BasicButtonModel.this.setMouseInside(bl);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicButtonModel.this.mousePressed && mouseEvent.getButton() == 1) {
                BasicButtonModel.this.setMousePressed(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicButtonModel.this.mousePressed && mouseEvent.getButton() == 1) {
                boolean bl = BasicButtonModel.this.owner.contains(mouseEvent.getX(), mouseEvent.getY());
                if (bl && BasicButtonModel.this.isEnabled()) {
                    BasicButtonModel.this.trigger();
                }
                BasicButtonModel.this.setMousePressed(false);
                if (BasicButtonModel.this.mouseInside != bl) {
                    BasicButtonModel.this.setMouseInside(bl);
                }
            }
        }
    }
}

