/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.DefaultStackDockComponent;
import bibliothek.gui.dock.themes.color.TabColor;
import java.awt.Color;

public class BasicStackDockComponent
extends DefaultStackDockComponent {
    private StackDockStation station;

    public BasicStackDockComponent(StackDockStation stackDockStation) {
        this.station = stackDockStation;
    }

    protected DefaultStackDockComponent.Tab createTab(Dockable dockable) {
        return new BasicTab(dockable);
    }

    public boolean hasBorder() {
        return false;
    }

    protected class BasicTab
    extends DefaultStackDockComponent.Tab
    implements DockableFocusListener {
        private TabColor colorForeground;
        private TabColor colorForegroundSelected;
        private TabColor colorForegroundFocused;
        private TabColor colorBackground;
        private TabColor colorBackgroundSelected;
        private TabColor colorBackgroundFocused;
        private TabColor[] colors;
        private DockController controller;

        public BasicTab(Dockable dockable) {
            super(dockable);
            this.colorForeground = new BasicTabColor("stack.tab.foreground");
            this.colorForegroundSelected = new BasicTabColor("stack.tab.foreground.selected");
            this.colorForegroundFocused = new BasicTabColor("stack.tab.foreground.focused");
            this.colorBackground = new BasicTabColor("stack.tab.background");
            this.colorBackgroundSelected = new BasicTabColor("stack.tab.background.selected");
            this.colorBackgroundFocused = new BasicTabColor("stack.tab.background.focused");
            this.colors = new TabColor[]{this.colorForeground, this.colorForegroundSelected, this.colorForegroundFocused, this.colorBackground, this.colorBackgroundSelected, this.colorBackgroundFocused};
        }

        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this);
            }
            super.setController(dockController);
            this.controller = dockController;
            for (TabColor tabColor : this.colors) {
                tabColor.connect(dockController);
            }
            if (dockController != null) {
                dockController.addDockableFocusListener(this);
            }
            this.updateColors();
        }

        private void updateColors() {
            int n = BasicStackDockComponent.this.station.indexOf(this.getDockable());
            if (n >= 0 && n < BasicStackDockComponent.this.getTabCount()) {
                boolean bl = this.controller == null ? false : this.controller.getFocusedDockable() == this.getDockable();
                boolean bl2 = n == BasicStackDockComponent.this.getSelectedIndex();
                Color color = null;
                Color color2 = null;
                if (bl) {
                    color = (Color)this.colorForegroundFocused.value();
                    color2 = (Color)this.colorBackgroundFocused.value();
                } else if (bl2) {
                    color = (Color)this.colorForegroundSelected.value();
                    color2 = (Color)this.colorBackgroundSelected.value();
                } else {
                    color = (Color)this.colorForeground.value();
                    color2 = (Color)this.colorBackground.value();
                }
                BasicStackDockComponent.this.setForegroundAt(n, color);
                BasicStackDockComponent.this.setBackgroundAt(n, color2);
            }
        }

        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            this.updateColors();
        }

        private class BasicTabColor
        extends TabColor {
            public BasicTabColor(String string) {
                super(string, BasicStackDockComponent.this.station, BasicTab.this.dockable, null);
            }

            protected void changed(Color color, Color color2) {
                BasicTab.this.updateColors();
            }
        }
    }
}

