/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerFocusTraversalPolicy;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class BasicDockableDisplayer
extends JPanel
implements DockableDisplayer {
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private DockStation station;
    private DockController controller;
    private Hints hints = new Hints();
    private boolean respectBorderHint = false;
    private boolean defaultBorderHint = true;

    public BasicDockableDisplayer() {
        this(null, null);
    }

    public BasicDockableDisplayer(Dockable dockable, DockTitle dockTitle) {
        this(dockable, dockTitle, DockableDisplayer.Location.TOP);
    }

    public BasicDockableDisplayer(Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        super(null);
        this.init(dockable, dockTitle, location);
    }

    protected BasicDockableDisplayer(boolean bl) {
        super(null);
        if (bl) {
            this.init(null, null, DockableDisplayer.Location.TOP);
        }
    }

    protected void init(Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        this.setTitleLocation(location);
        this.setDockable(dockable);
        this.setTitle(dockTitle);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new DisplayerFocusTraversalPolicy(this), true));
    }

    public void setController(DockController dockController) {
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public void setStation(DockStation dockStation) {
        this.station = dockStation;
    }

    public DockStation getStation() {
        return this.station;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.configureDisplayerHints(null);
            this.removeDockable(this.dockable.getComponent());
        }
        this.hints.setShowBorderHint(null);
        this.dockable = dockable;
        if (dockable != null) {
            this.addDockable(dockable.getComponent());
            this.dockable.configureDisplayerHints(this.hints);
        }
        this.revalidate();
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        if (location == null) {
            location = DockableDisplayer.Location.TOP;
        }
        this.location = location;
        if (this.title != null) {
            this.title.setOrientation(this.orientation(location));
        }
        this.revalidate();
    }

    protected DockTitle.Orientation orientation(DockableDisplayer.Location location) {
        switch (location) {
            case TOP: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case BOTTOM: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case LEFT: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case RIGHT: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public void setTitle(DockTitle dockTitle) {
        if (this.title != null) {
            this.removeTitle(this.title.getComponent());
        }
        this.title = dockTitle;
        if (dockTitle != null) {
            dockTitle.setOrientation(this.orientation(this.location));
            this.addTitle(dockTitle.getComponent());
        }
        this.revalidate();
    }

    protected void addDockable(Component component) {
        this.add(component);
    }

    protected void removeDockable(Component component) {
        this.remove(component);
    }

    protected Component getComponent(Dockable dockable) {
        return dockable.getComponent();
    }

    protected void addTitle(Component component) {
        this.add(component);
    }

    protected void removeTitle(Component component) {
        this.remove(component);
    }

    protected Component getComponent(DockTitle dockTitle) {
        return dockTitle.getComponent();
    }

    public boolean titleContains(int n, int n2) {
        DockTitle dockTitle = this.getTitle();
        if (dockTitle == null) {
            return false;
        }
        Component component = this.getComponent(dockTitle);
        Point point = new Point(n, n2);
        point = SwingUtilities.convertPoint(this, point, component);
        point.x -= component.getX();
        point.y -= component.getY();
        return component.contains(point);
    }

    public Component getComponent() {
        return this;
    }

    public Dimension getMinimumSize() {
        Cloneable cloneable;
        Dimension dimension;
        if (this.title == null && this.dockable != null) {
            dimension = this.getComponent(this.dockable).getMinimumSize();
        } else if (this.dockable == null && this.title != null) {
            dimension = this.getComponent(this.title).getMinimumSize();
        } else if (this.dockable == null && this.title == null) {
            dimension = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            cloneable = this.getComponent(this.title).getMinimumSize();
            dimension = this.getComponent(this.dockable).getMinimumSize();
            dimension = new Dimension(dimension.width + ((Dimension)cloneable).width, Math.max(dimension.height, ((Dimension)cloneable).height));
        } else {
            cloneable = this.getComponent(this.title).getMinimumSize();
            dimension = this.getComponent(this.dockable).getMinimumSize();
            dimension = new Dimension(Math.max(((Dimension)cloneable).width, dimension.width), ((Dimension)cloneable).height + dimension.height);
        }
        cloneable = this.getInsets();
        if (cloneable != null) {
            dimension = new Dimension(dimension.width + cloneable.left + cloneable.right, dimension.height + cloneable.top + cloneable.bottom);
        }
        return dimension;
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        if (this.title == null && this.dockable == null) {
            return;
        }
        n3 = Math.max(0, n3);
        n4 = Math.max(0, n4);
        if (this.title == null) {
            this.getComponent(this.dockable).setBounds(n, n2, n3, n4);
        } else if (this.dockable == null) {
            this.getComponent(this.title).setBounds(n, n2, n3, n4);
        } else {
            Dimension dimension = this.getComponent(this.title).getPreferredSize();
            int n5 = dimension.width;
            int n6 = dimension.height;
            if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
                n5 = Math.min(n5, n3);
                n6 = n4;
            } else {
                n5 = n3;
                n6 = Math.min(n6, n4);
            }
            if (this.location == DockableDisplayer.Location.LEFT) {
                this.getComponent(this.title).setBounds(n, n2, n5, n6);
                this.getComponent(this.dockable).setBounds(n + n5, n2, n3 - n5, n4);
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                this.getComponent(this.title).setBounds(n + n3 - n5, n2, n5, n6);
                this.getComponent(this.dockable).setBounds(n, n2, n3 - n5, n6);
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                this.getComponent(this.title).setBounds(n, n2 + n4 - n6, n5, n6);
                this.getComponent(this.dockable).setBounds(n, n2, n5, n4 - n6);
            } else {
                this.getComponent(this.title).setBounds(n, n2, n5, n6);
                this.getComponent(this.dockable).setBounds(n, n2 + n6, n5, n4 - n6);
            }
        }
    }

    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.title == null && this.dockable == null) {
            return insets;
        }
        if (this.title == null) {
            return insets;
        }
        if (this.dockable != null) {
            Dimension dimension = this.getComponent(this.title).getPreferredSize();
            if (this.location == DockableDisplayer.Location.LEFT) {
                insets.left += dimension.width;
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                insets.right += dimension.width;
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                insets.bottom += dimension.height;
            } else {
                insets.top += dimension.height;
            }
        }
        return insets;
    }

    protected Hints getHints() {
        return this.hints;
    }

    public void setRespectBorderHint(boolean bl) {
        if (this.respectBorderHint != bl) {
            this.respectBorderHint = bl;
            this.updateBorder();
        }
    }

    public boolean isRespectBorderHint() {
        return this.respectBorderHint;
    }

    public void setDefaultBorderHint(boolean bl) {
        if (this.defaultBorderHint != bl) {
            this.defaultBorderHint = bl;
            this.updateBorder();
        }
    }

    public boolean getDefaultBorderHint() {
        return this.defaultBorderHint;
    }

    protected void updateBorder() {
        if (this.respectBorderHint) {
            boolean bl = this.hints.getShowBorderHint();
            if (bl) {
                this.setBorder(this.getDefaultBorder());
            } else {
                this.setBorder(null);
            }
        }
    }

    protected Border getDefaultBorder() {
        return BorderFactory.createBevelBorder(0);
    }

    protected class Hints
    implements DockableDisplayerHints {
        private Boolean border;

        protected Hints() {
        }

        public void setShowBorderHint(Boolean bl) {
            if (this.border != bl) {
                this.border = bl;
                BasicDockableDisplayer.this.updateBorder();
            }
        }

        public boolean getShowBorderHint() {
            if (this.border != null) {
                return this.border;
            }
            return BasicDockableDisplayer.this.defaultBorderHint;
        }
    }
}

