/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Condition;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class BasicDockTitle
extends AbstractDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        @Override
        public DockTitle createDockableTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
            return new BasicDockTitle(dockable, dockTitleVersion);
        }

        @Override
        public <D extends Dockable & DockStation> DockTitle createStationTitle(D d, DockTitleVersion dockTitleVersion) {
            return new BasicDockTitle(d, dockTitleVersion);
        }
    };
    private TitleColor activeLeftColor = new BasicTitleColor("title.active.left", Color.BLACK);
    private TitleColor inactiveLeftColor = new BasicTitleColor("title.inactive.left", Color.DARK_GRAY);
    private TitleColor activeRightColor = new BasicTitleColor("title.active.right", Color.DARK_GRAY);
    private TitleColor inactiveRightColor = new BasicTitleColor("title.inactive.right", Color.LIGHT_GRAY);
    private TitleColor activeTextColor = new BasicTitleColor("title.active.text", Color.WHITE);
    private TitleColor inactiveTextColor = new BasicTitleColor("title.inactive.text", Color.BLACK);
    private GradientPaint gradient;

    public BasicDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this(dockable, dockTitleVersion, true);
    }

    protected BasicDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        super(dockable, dockTitleVersion);
        this.setActive(false);
        this.addColor(this.activeLeftColor);
        this.addColor(this.inactiveLeftColor);
        this.addColor(this.activeRightColor);
        this.addColor(this.inactiveRightColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveTextColor);
        if (bl) {
            this.addConditionalFont("title.active", TitleFont.KIND_TITLE_FONT, new Condition(){

                public boolean getState() {
                    return BasicDockTitle.this.isActive();
                }
            }, null);
            this.addConditionalFont("title.inactive", TitleFont.KIND_TITLE_FONT, new Condition(){

                public boolean getState() {
                    return !BasicDockTitle.this.isActive();
                }
            }, null);
        }
    }

    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.gradient = null;
    }

    public void validate() {
        this.gradient = null;
        super.validate();
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        this.gradient = null;
        super.setOrientation(orientation);
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gradient == null) {
            this.gradient = this.isActive() ? this.getGradient((Color)this.activeLeftColor.value(), (Color)this.activeRightColor.value(), jComponent) : this.getGradient((Color)this.inactiveLeftColor.value(), (Color)this.inactiveRightColor.value(), jComponent);
        }
        graphics2D.setPaint(this.gradient);
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    protected GradientPaint getGradient(Color color, Color color2, Component component) {
        GradientPaint gradientPaint;
        if (this.getOrientation().isHorizontal()) {
            float f = (float)component.getHeight() / 2.0f;
            gradientPaint = new GradientPaint(0.0f, f, color, component.getWidth(), f, color2, false);
        } else {
            float f = (float)component.getWidth() / 2.0f;
            gradientPaint = new GradientPaint(f, 0.0f, color, f, component.getHeight(), color2, false);
        }
        return gradientPaint;
    }

    public Color getActiveLeftColor() {
        return (Color)this.activeLeftColor.value();
    }

    public TitleColor getActiveLeftTitleColor() {
        return this.activeLeftColor;
    }

    public void setActiveLeftColor(Color color) {
        this.activeLeftColor.setValue(color);
    }

    public void setActiveLeftColorId(String string) {
        this.activeLeftColor.setId(string);
    }

    public Color getActiveRightColor() {
        return (Color)this.activeRightColor.value();
    }

    public TitleColor getActiveRightTitleColor() {
        return this.activeRightColor;
    }

    public void setActiveRightColor(Color color) {
        this.activeRightColor.setValue(color);
    }

    public void setActiveRightColorId(String string) {
        this.activeRightColor.setId(string);
    }

    public Color getActiveTextColor() {
        return (Color)this.activeTextColor.value();
    }

    public TitleColor getActiveTextTitleColor() {
        return this.activeTextColor;
    }

    public void setActiveTextColor(Color color) {
        this.activeTextColor.setValue(color);
    }

    public void setActiveTextColorId(String string) {
        this.activeTextColor.setId(string);
    }

    public Color getInactiveLeftColor() {
        return (Color)this.inactiveLeftColor.value();
    }

    public TitleColor getInactiveLeftTitleColor() {
        return this.inactiveLeftColor;
    }

    public void setInactiveLeftColor(Color color) {
        this.inactiveLeftColor.setValue(color);
    }

    public void setInactiveLeftColorId(String string) {
        this.inactiveLeftColor.setId(string);
    }

    public Color getInactiveRightColor() {
        return (Color)this.inactiveRightColor.value();
    }

    public TitleColor getInactiveRightTitleColor() {
        return this.inactiveRightColor;
    }

    public void setInactiveRightColor(Color color) {
        this.inactiveRightColor.setValue(color);
    }

    public void setInactiveRightColorId(String string) {
        this.activeRightColor.setId(string);
    }

    public Color getInactiveTextColor() {
        return (Color)this.inactiveTextColor.value();
    }

    public TitleColor getInactiveTextTitleColor() {
        return this.inactiveTextColor;
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setValue(color);
    }

    public void setInactiveTextColorId(String string) {
        this.inactiveTextColor.setId(string);
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        this.updateColors();
        this.updateFonts();
    }

    protected void updateColors() {
        this.gradient = null;
        if (this.isActive()) {
            if (this.activeTextColor != null) {
                this.setForeground((Color)this.activeTextColor.value());
            }
        } else if (this.inactiveTextColor != null) {
            this.setForeground((Color)this.inactiveTextColor.value());
        }
        this.repaint();
    }

    private class BasicTitleColor
    extends TitleColor {
        public BasicTitleColor(String string, Color color) {
            super(string, BasicDockTitle.this, color);
        }

        protected void changed(Color color, Color color2) {
            BasicDockTitle.this.gradient = null;
            BasicDockTitle.this.updateColors();
        }
    }
}

