/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.gui.dock.themes.nostack.NoStackAcceptance;
import bibliothek.gui.dock.themes.nostack.NoStackTitleFactory;
import bibliothek.gui.dock.title.DockTitleFactory;
import java.net.URI;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoStackTheme
implements DockTheme {
    private DockTheme base;
    private NoStackAcceptance acceptance = new NoStackAcceptance();

    public static <T extends DockTheme> ThemeFactory getFactory(Class<T> clazz, ResourceBundle resourceBundle, final DockUI dockUI) {
        final ThemePropertyFactory<T> themePropertyFactory = new ThemePropertyFactory<T>(clazz, resourceBundle, dockUI);
        return new ThemeFactory(){

            public DockTheme create() {
                return new NoStackTheme(themePropertyFactory.create());
            }

            public URI[] getWebpages() {
                return themePropertyFactory.getWebpages();
            }

            public String[] getAuthors() {
                String[] stringArray;
                for (String string : stringArray = themePropertyFactory.getAuthors()) {
                    if (!string.equals("Benjamin Sigg")) continue;
                    return stringArray;
                }
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = "Benjamin Sigg";
                return stringArray2;
            }

            public String getDescription() {
                if (dockUI == null) {
                    return DockUI.getDefaultDockUI().getString("theme.small.description");
                }
                return dockUI.getString("theme.small.description");
            }

            public String getName() {
                String string = themePropertyFactory.getName();
                String string2 = null;
                string2 = dockUI != null ? dockUI.getString("theme.small") : DockUI.getDefaultDockUI().getString("theme.small");
                if (string == null) {
                    return string2;
                }
                return string2 + " \"" + string + "\"";
            }
        };
    }

    public NoStackTheme(DockTheme dockTheme) {
        if (dockTheme == null) {
            throw new IllegalArgumentException("Base theme must not be null");
        }
        this.base = dockTheme;
    }

    @Override
    public Combiner getCombiner(DockStation dockStation) {
        return this.base.getCombiner(dockStation);
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.base.getDisplayFactory(dockStation);
    }

    @Override
    public StationPaint getPaint(DockStation dockStation) {
        return this.base.getPaint(dockStation);
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController dockController) {
        return new NoStackTitleFactory(this.base.getTitleFactory(dockController));
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.base.getMovingImageFactory(dockController);
    }

    @Override
    public DockableSelection getDockableSelection(DockController dockController) {
        return this.base.getDockableSelection(dockController);
    }

    @Override
    public void install(DockController dockController) {
        this.base.install(dockController);
        dockController.addAcceptance(this.acceptance);
    }

    @Override
    public void uninstall(DockController dockController) {
        this.base.uninstall(dockController);
        dockController.removeAcceptance(this.acceptance);
    }
}

