/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.extension.gui.dock.util.Path;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.BasicColorScheme;
import bibliothek.gui.dock.themes.basic.BasicCombiner;
import bibliothek.gui.dock.themes.basic.BasicDisplayerFactory;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.basic.BasicDockableSelection;
import bibliothek.gui.dock.themes.basic.BasicMovingImageFactory;
import bibliothek.gui.dock.themes.basic.BasicStackDockComponent;
import bibliothek.gui.dock.themes.basic.BasicStationPaint;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.themes.color.DockableSelectionColor;
import bibliothek.gui.dock.themes.color.StationPaintColor;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.gui.dock.util.laf.LookAndFeelColorsListener;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.awt.Color;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThemeProperties(nameBundle="theme.basic", descriptionBundle="theme.basic.description", authors={"Benjamin Sigg"}, webpages={})
public class BasicTheme
implements DockTheme {
    private Combiner combiner;
    private StationPaint paint;
    private DisplayerFactory displayerFactory;
    private DockTitleFactory titleFactory;
    private DockableMovingImageFactory movingImage;
    private StackDockComponentFactory stackDockComponentFactory;
    public static final PropertyKey<ColorScheme> BASIC_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.BasicTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> propertyKey, DockProperties dockProperties) {
            return new BasicColorScheme();
        }
    }, true);
    private PropertyValue<ColorScheme> colorScheme = new PropertyValue<ColorScheme>(BASIC_COLOR_SCHEME){

        @Override
        protected void valueChanged(ColorScheme colorScheme, ColorScheme colorScheme2) {
            ColorScheme colorScheme3 = (ColorScheme)this.getValue();
            if (colorScheme3 != null) {
                colorScheme3.updateUI();
            }
            BasicTheme.this.updateColors();
        }
    };
    private DockableSelection selection;
    private DockController controller;
    private UIListener uiListener = new UIListener(){

        public void updateUI(DockController dockController) {
            BasicTheme.this.updateUI();
        }

        public void themeChanged(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
        }

        public void themeWillChange(DockController dockController, DockTheme dockTheme, DockTheme dockTheme2) {
        }
    };
    private LookAndFeelColorsListener colorListener = new LookAndFeelColorsListener(){

        public void colorChanged(String string) {
            this.colorsChanged();
        }

        public void colorsChanged() {
            if (((ColorScheme)BasicTheme.this.colorScheme.getValue()).updateUI()) {
                BasicTheme.this.updateColors();
            }
        }
    };

    public BasicTheme() {
        this.setCombiner(new BasicCombiner());
        this.setPaint(new BasicStationPaint());
        this.setDisplayerFactory(new BasicDisplayerFactory());
        this.setTitleFactory(new BasicDockTitleFactory());
        this.setMovingImageFactory(new BasicMovingImageFactory());
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            public StackDockComponent create(StackDockStation stackDockStation) {
                return new BasicStackDockComponent(stackDockStation);
            }
        });
        this.setDockableSelection(new BasicDockableSelection());
    }

    @Override
    public void install(DockController dockController) {
        if (this.controller != null) {
            throw new IllegalStateException("Theme is already in use");
        }
        this.controller = dockController;
        dockController.addUIListener(this.uiListener);
        DockUI.getDefaultDockUI().addLookAndFeelColorsListener(this.colorListener);
        this.updateUI();
        dockController.getProperties().set(StackDockStation.COMPONENT_FACTORY, this.stackDockComponentFactory);
        this.colorScheme.setProperties(dockController);
        this.updateColors();
    }

    @Override
    public void uninstall(DockController dockController) {
        if (this.controller != dockController) {
            throw new IllegalArgumentException("Trying to uninstall a controller which is not installed");
        }
        dockController.getProperties().toDefault(StackDockStation.COMPONENT_FACTORY);
        dockController.getColors().clear(Priority.THEME);
        dockController.removeUIListener(this.uiListener);
        DockUI.getDefaultDockUI().removeLookAndFeelColorsListener(this.colorListener);
        this.colorScheme.setProperties((DockProperties)null);
        this.controller = null;
    }

    public void updateUI() {
        ColorScheme colorScheme = this.colorScheme.getValue();
        if (colorScheme != null && colorScheme.updateUI()) {
            this.updateColors();
        }
        if (this.selection != null) {
            SwingUtilities.updateComponentTreeUI(this.selection.getComponent());
        }
    }

    protected void updateColors() {
        ColorScheme colorScheme = this.colorScheme.getValue();
        if (this.controller != null && colorScheme != null) {
            this.controller.getColors().lockUpdate();
            this.controller.getColors().clear(Priority.THEME);
            colorScheme.transmitAll(Priority.THEME, this.controller.getColors());
            this.updateColor("title.active.left", null);
            this.updateColor("title.inactive.left", null);
            this.updateColor("title.active.right", null);
            this.updateColor("title.inactive.right", null);
            this.updateColor("title.active.text", null);
            this.updateColor("title.inactive.text", null);
            this.updateColor("title.station.active", null);
            this.updateColor("title.station.active.text", null);
            this.updateColor("title.station.inactive", null);
            this.updateColor("title.station.inactive.text", null);
            this.updateColor("title.flap.active", null);
            this.updateColor("title.flap.active.text", null);
            this.updateColor("title.flap.inactive", null);
            this.updateColor("title.flap.inactive.text", null);
            this.updateColor("title.flap.selected", null);
            this.updateColor("title.flap.selected.text", null);
            this.updateColor("stack.tab.foreground", null);
            this.updateColor("stack.tab.foreground.selected", null);
            this.updateColor("stack.tab.foreground.focused", null);
            this.updateColor("stack.tab.background", null);
            this.updateColor("stack.tab.background.selected", null);
            this.updateColor("stack.tab.background.focused", null);
            this.updateColor("paint.line", null);
            this.updateColor("paint.divider", null);
            this.updateColor("paint.insertion", null);
            this.updateColorBridge(DockColor.KIND_DOCK_COLOR);
            this.updateColorBridge(TabColor.KIND_TAB_COLOR);
            this.updateColorBridge(TitleColor.KIND_TITLE_COLOR);
            this.updateColorBridge(ActionColor.KIND_ACTION_COLOR);
            this.updateColorBridge(DisplayerColor.KIND_DISPLAYER_COLOR);
            this.updateColorBridge(StationPaintColor.KIND_STATION_PAINT_COLOR);
            this.updateColorBridge(DockableSelectionColor.KIND_DOCKABLE_SELECTION_COLOR);
            this.controller.getColors().unlockUpdate();
        }
    }

    protected void updateColor(String string, Color color) {
        Color color2 = this.colorScheme.getValue().getColor(string);
        if (color2 == null) {
            color2 = color;
        }
        this.controller.getColors().put(Priority.THEME, string, color2);
    }

    protected <P extends DockColor> void updateColorBridge(Path path) {
        ColorBridgeFactory colorBridgeFactory = this.colorScheme.getValue().getBridgeFactory(path);
        if (colorBridgeFactory != null) {
            ColorBridge colorBridge = colorBridgeFactory.create(this.controller.getColors());
            this.controller.getColors().publish(Priority.THEME, path, colorBridge);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    protected void setColorSchemeKey(PropertyKey<ColorScheme> propertyKey) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.colorScheme.setKey(propertyKey);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.setValue(colorScheme);
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme.getValue();
    }

    public void setStackDockComponentFactory(StackDockComponentFactory stackDockComponentFactory) {
        this.stackDockComponentFactory = stackDockComponentFactory;
    }

    public void setMovingImageFactory(DockableMovingImageFactory dockableMovingImageFactory) {
        if (dockableMovingImageFactory == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        this.movingImage = dockableMovingImageFactory;
    }

    public void setCombiner(Combiner combiner) {
        if (combiner == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        this.combiner = combiner;
    }

    public void setPaint(StationPaint stationPaint) {
        if (stationPaint == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        this.paint = stationPaint;
    }

    public void setDisplayerFactory(DisplayerFactory displayerFactory) {
        if (displayerFactory == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        this.displayerFactory = displayerFactory;
    }

    public void setTitleFactory(DockTitleFactory dockTitleFactory) {
        if (dockTitleFactory == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        this.titleFactory = dockTitleFactory;
    }

    public void setDockableSelection(DockableSelection dockableSelection) {
        if (dockableSelection == null) {
            throw new IllegalArgumentException("selection must not be null");
        }
        this.selection = dockableSelection;
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.movingImage;
    }

    @Override
    public Combiner getCombiner(DockStation dockStation) {
        return this.combiner;
    }

    @Override
    public StationPaint getPaint(DockStation dockStation) {
        return this.paint;
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.displayerFactory;
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController dockController) {
        return this.titleFactory;
    }

    @Override
    public DockableSelection getDockableSelection(DockController dockController) {
        return this.selection;
    }
}

