/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationLayout;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackDockStationFactory
implements DockFactory<StackDockStation, StackDockStationLayout> {
    public static final String ID = "StackDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public StackDockStationLayout getLayout(StackDockStation stackDockStation, Map<Dockable, Integer> map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Dockable dockable = stackDockStation.getFrontDockable();
        int n = -1;
        int n2 = stackDockStation.getDockableCount();
        for (int i = 0; i < n2; ++i) {
            Dockable dockable2 = stackDockStation.getDockable(i);
            Integer n3 = map.get(dockable2);
            if (n3 == null) continue;
            arrayList.add(n3);
            if (dockable != dockable2) continue;
            n = n3;
        }
        int[] nArray = new int[arrayList.size()];
        int n4 = arrayList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = (Integer)arrayList.get(n2);
        }
        return new StackDockStationLayout(n, nArray);
    }

    @Override
    public void estimateLocations(StackDockStationLayout stackDockStationLayout, Map<Integer, DockLayoutInfo> map) {
        for (int n : stackDockStationLayout.getChildren()) {
            DockLayoutInfo dockLayoutInfo = map.get(n);
            if (dockLayoutInfo == null) continue;
            StackDockProperty stackDockProperty = new StackDockProperty(n);
            dockLayoutInfo.setLocation(stackDockProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setLayout(StackDockStation stackDockStation, StackDockStationLayout stackDockStationLayout, Map<Integer, Dockable> map) {
        DockController dockController = stackDockStation.getController();
        try {
            void object;
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int i = stackDockStation.getDockableCount() - 1;
            while (object >= 0) {
                stackDockStation.remove((int)object);
                --object;
            }
            for (int n : stackDockStationLayout.getChildren()) {
                Dockable dockable = map.get(n);
                if (dockable == null) continue;
                stackDockStation.drop(dockable);
            }
            Dockable dockable = map.get(stackDockStationLayout.getSelected());
            if (dockable != null) {
                stackDockStation.setFrontDockable(dockable);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public void setLayout(StackDockStation stackDockStation, StackDockStationLayout stackDockStationLayout) {
    }

    @Override
    public StackDockStation layout(StackDockStationLayout stackDockStationLayout, Map<Integer, Dockable> map) {
        StackDockStation stackDockStation = this.createStation();
        this.setLayout(stackDockStation, stackDockStationLayout, map);
        return stackDockStation;
    }

    @Override
    public StackDockStation layout(StackDockStationLayout stackDockStationLayout) {
        StackDockStation stackDockStation = this.createStation();
        this.setLayout(stackDockStation, stackDockStationLayout);
        return stackDockStation;
    }

    @Override
    public void write(StackDockStationLayout stackDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeInt(stackDockStationLayout.getSelected());
        dataOutputStream.writeInt(stackDockStationLayout.getChildren().length);
        for (int n : stackDockStationLayout.getChildren()) {
            dataOutputStream.writeInt(n);
        }
    }

    @Override
    public StackDockStationLayout read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return new StackDockStationLayout(n, nArray);
    }

    @Override
    public void write(StackDockStationLayout stackDockStationLayout, XElement xElement) {
        if (stackDockStationLayout.getSelected() >= 0) {
            xElement.addElement("selected").setInt(stackDockStationLayout.getSelected());
        }
        XElement xElement2 = xElement.addElement("children");
        for (int n : stackDockStationLayout.getChildren()) {
            xElement2.addElement("child").addInt("id", n);
        }
    }

    @Override
    public StackDockStationLayout read(XElement xElement) {
        int[] nArray;
        XElement xElement2;
        XElement xElement3 = xElement.getElement("selected");
        int n = -1;
        if (xElement3 != null) {
            n = xElement3.getInt();
        }
        if ((xElement2 = xElement.getElement("children")) != null) {
            XElement[] xElementArray = xElement2.getElements("child");
            nArray = new int[xElementArray.length];
            int n2 = xElementArray.length;
            for (int i = 0; i < n2; ++i) {
                nArray[i] = xElementArray[i].getInt("id");
            }
        } else {
            nArray = new int[]{};
        }
        return new StackDockStationLayout(n, nArray);
    }

    protected StackDockStation createStation() {
        return new StackDockStation();
    }
}

