/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DefaultStackDockComponent
extends JTabbedPane
implements StackDockComponent {
    private List<Tab> dockables = new ArrayList<Tab>();
    private DockController controller;
    private RemoteRelocator relocator;

    public DefaultStackDockComponent() {
        super(3);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        this.insertTab(string, icon, component, (String)null, n);
        Tab tab = this.createTab(dockable);
        this.dockables.add(n, tab);
        tab.setController(this.controller);
    }

    protected Tab createTab(Dockable dockable) {
        return new Tab(dockable);
    }

    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.addTab(string, icon, component);
        Tab tab = this.createTab(dockable);
        this.dockables.add(tab);
        tab.setController(this.controller);
    }

    public void removeAll() {
        for (Tab tab : this.dockables) {
            tab.setController(null);
        }
        super.removeAll();
        this.dockables.clear();
    }

    public void remove(int n) {
        Tab tab = this.dockables.remove(n);
        tab.setController(null);
        super.remove(n);
    }

    public Component getComponent() {
        return this;
    }

    public void setTooltipAt(int n, String string) {
        this.setToolTipTextAt(n, string);
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.relocator != null) {
                this.relocator.cancel();
                this.relocator = null;
            }
            this.controller = dockController;
            for (Tab tab : this.dockables) {
                tab.setController(dockController);
            }
        }
    }

    public boolean hasBorder() {
        return true;
    }

    private class Listener
    extends MouseInputAdapter {
        private Listener() {
        }

        private void updateRelocator(int n, int n2) {
            boolean bl;
            boolean bl2 = bl = DefaultStackDockComponent.this.controller == null || !DefaultStackDockComponent.this.controller.getRelocator().isDragOnlyTitel();
            if (DefaultStackDockComponent.this.relocator != null) {
                if (!bl) {
                    DefaultStackDockComponent.this.relocator.cancel();
                    DefaultStackDockComponent.this.relocator = null;
                }
                return;
            }
            if (!bl) {
                return;
            }
            int n3 = DefaultStackDockComponent.this.getTabCount();
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle = DefaultStackDockComponent.this.getBoundsAt(i);
                if (rectangle == null || !rectangle.contains(n, n2)) continue;
                DefaultStackDockComponent.this.relocator = ((Tab)DefaultStackDockComponent.this.dockables.get(i)).relocator;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY());
            if (DefaultStackDockComponent.this.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.relocator.init(point.x, point.y, 0, 0, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.relocator = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY());
            if (DefaultStackDockComponent.this.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.relocator.drop(point.x, point.y, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.relocator = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY());
            if (DefaultStackDockComponent.this.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.relocator.drag(point.x, point.y, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.relocator = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            }
        }
    }

    protected class Tab {
        protected Dockable dockable;
        private RemoteRelocator relocator;

        public Tab(Dockable dockable) {
            this.dockable = dockable;
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public void setController(DockController dockController) {
            this.relocator = dockController == null ? null : dockController.getRelocator().createRemote(this.dockable);
        }
    }
}

