/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackTabListLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CombinedStackDockComponent<C extends CombinedTab>
implements StackDockComponent {
    private JPanel panel;
    private List<C> buttons = new ArrayList<C>();
    private DockController controller;
    private JPanel buttonPanel = new JPanel(new StackTabListLayout());
    private List<Component> components = new ArrayList<Component>();
    private JPanel componentPanel = new JPanel(){

        public void doLayout() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                this.getComponent(i).setBounds(0, 0, n, n2);
            }
        }

        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension(0, 0);
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension dimension2 = this.getComponent(i).getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }
    };
    private int selectedIndex = -1;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public CombinedStackDockComponent() {
        this.panel = new JPanel(null){

            @Deprecated
            public void reshape(int n, int n2, int n3, int n4) {
                super.reshape(n, n2, n3, n4);
                this.doLayout();
            }

            public void doLayout() {
                Dimension dimension = CombinedStackDockComponent.this.buttonPanel.getPreferredSize();
                int n = Math.min(dimension.height, this.getHeight() - 1);
                CombinedStackDockComponent.this.componentPanel.setBounds(0, 0, this.getWidth(), this.getHeight() - n);
                CombinedStackDockComponent.this.buttonPanel.setBounds(0, this.getHeight() - n, this.getWidth(), n);
            }

            public Dimension getMinimumSize() {
                Dimension dimension = CombinedStackDockComponent.this.componentPanel.getMinimumSize();
                Dimension dimension2 = CombinedStackDockComponent.this.buttonPanel.getMinimumSize();
                return new Dimension(dimension.width, dimension.height + dimension2.height);
            }
        };
        this.panel.add(this.buttonPanel);
        this.panel.add(this.componentPanel);
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                for (CombinedTab combinedTab : this.buttons) {
                    this.controller.removeRepresentative(combinedTab);
                }
            }
            this.controller = dockController;
            if (this.controller != null) {
                for (CombinedTab combinedTab : this.buttons) {
                    this.controller.addRepresentative(combinedTab);
                }
            }
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public C getTab(int n) {
        return (C)((CombinedTab)this.buttons.get(n));
    }

    protected abstract C createTab(Dockable var1);

    protected abstract void destroy(C var1);

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireStateChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int n) {
        if (this.selectedIndex != n) {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.buttons.size()) {
                ((CombinedTab)this.buttons.get(this.selectedIndex)).getComponent().repaint();
            }
            this.selectedIndex = n;
            int n2 = this.components.size();
            for (int i = 0; i < n2; ++i) {
                this.components.get(i).setVisible(i == n);
            }
            if (n >= 0 && n < this.buttons.size()) {
                ((CombinedTab)this.buttons.get(n)).getComponent().repaint();
                this.componentPanel.revalidate();
                this.componentPanel.repaint();
            }
            this.fireStateChange();
        }
    }

    @Override
    public Rectangle getBoundsAt(int n) {
        Rectangle rectangle = ((CombinedTab)this.buttons.get(n)).getComponent().getBounds();
        rectangle.x += this.buttonPanel.getX();
        rectangle.y += this.buttonPanel.getY();
        return rectangle;
    }

    @Override
    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.insertTab(string, icon, component, dockable, this.getTabCount());
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        C c = this.createTab(dockable);
        if (this.controller != null) {
            this.controller.addRepresentative((DockElementRepresentative)c);
        }
        c.setText(string);
        c.setIcon(icon);
        this.buttons.add(n, c);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(component);
        this.components.add(n, jPanel);
        this.componentPanel.add(jPanel);
        this.buttonPanel.removeAll();
        int n2 = 0;
        for (CombinedTab combinedTab : this.buttons) {
            this.buttonPanel.add(combinedTab.getComponent());
            combinedTab.setIndex(n2++);
        }
        if (this.selectedIndex >= n) {
            ++this.selectedIndex;
        }
        this.setSelectedIndex(n);
        this.fireStateChange();
    }

    @Override
    public int getTabCount() {
        return this.buttons.size();
    }

    @Override
    public void removeAll() {
        this.components.clear();
        this.buttonPanel.removeAll();
        this.componentPanel.removeAll();
        this.selectedIndex = -1;
        for (CombinedTab combinedTab : this.buttons) {
            if (this.controller != null) {
                this.controller.removeRepresentative(combinedTab);
            }
            this.destroy(combinedTab);
        }
        this.buttons.clear();
        this.fireStateChange();
    }

    @Override
    public void remove(int n) {
        if (n == this.selectedIndex) {
            if (n == 0) {
                if (this.getTabCount() == 1) {
                    this.setSelectedIndex(-1);
                } else {
                    this.setSelectedIndex(1);
                }
            } else {
                this.setSelectedIndex(0);
            }
        }
        CombinedTab combinedTab = (CombinedTab)this.buttons.remove(n);
        this.buttonPanel.remove(combinedTab.getComponent());
        if (this.controller != null) {
            this.controller.removeRepresentative(combinedTab);
        }
        this.destroy(combinedTab);
        this.componentPanel.remove(this.components.remove(n));
        int n2 = 0;
        for (CombinedTab combinedTab2 : this.buttons) {
            combinedTab2.setIndex(n2++);
        }
        if (this.selectedIndex >= n) {
            --this.selectedIndex;
        }
        this.fireStateChange();
    }

    @Override
    public void setTitleAt(int n, String string) {
        ((CombinedTab)this.buttons.get(n)).setText(string);
    }

    @Override
    public void setTooltipAt(int n, String string) {
        ((CombinedTab)this.buttons.get(n)).setTooltip(string);
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        ((CombinedTab)this.buttons.get(n)).setIcon(icon);
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }
}

