/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import java.util.HashSet;
import java.util.Set;

public class SplitDockTree {
    private Key root;
    private Set<Dockable> dockables = new HashSet<Dockable>();

    public Key root(Dockable dockable) {
        this.root = this.put(dockable);
        return this.root;
    }

    public Key unroot() {
        Key key = this.root;
        this.root = null;
        return key;
    }

    public SplitDockTree root(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (key.getTree() != this) {
            throw new IllegalArgumentException("Key is not created by this tree");
        }
        if (key.parent != null) {
            throw new IllegalArgumentException("Key has a parent, and can't be the root");
        }
        this.root = key;
        return this;
    }

    public Key put(Dockable ... dockableArray) {
        return this.put(dockableArray, (Dockable)null);
    }

    public Key put(Dockable[] dockableArray, Dockable dockable) {
        if (dockableArray == null) {
            throw new IllegalArgumentException("Dockables must not be null");
        }
        if (dockableArray.length == 0) {
            throw new IllegalArgumentException("At least one Dockable is required");
        }
        for (Dockable dockable2 : dockableArray) {
            if (dockable2 == null) {
                throw new IllegalArgumentException("Entries of array must not be null");
            }
            if (this.dockables.add(dockable2)) continue;
            throw new IllegalArgumentException("Dockable already known");
        }
        return new Leaf(dockableArray, dockable);
    }

    public Key horizontal(Dockable dockable, Dockable dockable2) {
        return this.horizontal(this.put(dockable), this.put(dockable2));
    }

    public Key horizontal(Dockable dockable, Dockable dockable2, double d) {
        return this.horizontal(this.put(dockable), this.put(dockable2), d);
    }

    public Key horizontal(Key key, Key key2) {
        return this.horizontal(key, key2, 0.5);
    }

    public Key horizontal(Key key, Key key2, double d) {
        return new Node(key, key2, d, true);
    }

    public Key vertical(Dockable dockable, Dockable dockable2) {
        return this.vertical(this.put(dockable), this.put(dockable2));
    }

    public Key vertical(Dockable dockable, Dockable dockable2, double d) {
        return this.vertical(this.put(dockable), this.put(dockable2), d);
    }

    public Key vertical(Key key, Key key2) {
        return this.vertical(key, key2, 0.5);
    }

    public Key vertical(Key key, Key key2, double d) {
        return new Node(key, key2, d, false);
    }

    public Key getRoot() {
        return this.root;
    }

    public boolean isDockable(Key key) {
        return key.asLeaf() != null;
    }

    public boolean isNode(Key key) {
        return key.asNode() != null;
    }

    public Dockable[] getDockables() {
        return this.dockables.toArray(new Dockable[this.dockables.size()]);
    }

    public Dockable[] getDockables(Key key) {
        if (!this.isDockable(key)) {
            throw new IllegalArgumentException("Not a Dockable");
        }
        return key.asLeaf().dockables;
    }

    public Dockable getSelected(Key key) {
        if (!this.isDockable(key)) {
            throw new IllegalArgumentException("Not a Dockable");
        }
        return key.asLeaf().selected;
    }

    public boolean isHorizontal(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().horizontal;
    }

    public Key getLeft(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyA;
    }

    public Key getRight(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyB;
    }

    public Key getTop(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyA;
    }

    public Key getBottom(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyB;
    }

    public double getDivider(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().divider;
    }

    private class Node
    extends Key {
        public Key keyA;
        public Key keyB;
        public double divider;
        public boolean horizontal;

        public Node(Key key, Key key2, double d, boolean bl) {
            if (key.getTree() != this.getTree()) {
                throw new IllegalArgumentException("Key of first argument belongs not to this tree");
            }
            if (key2.getTree() != this.getTree()) {
                throw new IllegalArgumentException("Key of second argument belongs not to this tree");
            }
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("Divider out of bounds, must be between 0 and 1");
            }
            if (key.getParent() != null) {
                throw new IllegalArgumentException("First key already has a parent");
            }
            if (key2.getParent() != null) {
                throw new IllegalArgumentException("Second key already has a parent");
            }
            if (key == key2) {
                throw new IllegalArgumentException("The arguments must not be the same object");
            }
            if (key == SplitDockTree.this.root) {
                throw new IllegalArgumentException("First argument is the root, can't be a child of any other node");
            }
            if (key2 == SplitDockTree.this.root) {
                throw new IllegalArgumentException("Second argument is the root, can't be a child of any other node");
            }
            key.setParent((Key)this);
            key2.setParent((Key)this);
            this.keyA = key;
            this.keyB = key2;
            this.divider = d;
            this.horizontal = bl;
        }

        protected Node asNode() {
            return this;
        }
    }

    private class Leaf
    extends Key {
        public Dockable[] dockables;
        public Dockable selected;

        public Leaf(Dockable[] dockableArray, Dockable dockable) {
            this.dockables = new Dockable[dockableArray.length];
            System.arraycopy(dockableArray, 0, this.dockables, 0, dockableArray.length);
            this.selected = dockable;
        }

        public Leaf asLeaf() {
            return this;
        }
    }

    public abstract class Key {
        private Key parent;

        public SplitDockTree getTree() {
            return SplitDockTree.this;
        }

        public Key getParent() {
            return this.parent;
        }

        private void setParent(Key key) {
            this.parent = key;
        }

        protected Leaf asLeaf() {
            return null;
        }

        protected Node asNode() {
            return null;
        }
    }
}

