/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;

public class SplitDockStationLayout {
    private Entry root;
    private int fullscreen;

    public SplitDockStationLayout(Entry entry, int n) {
        this.root = entry;
        this.fullscreen = n;
    }

    public Entry getRoot() {
        return this.root;
    }

    public int getFullscreen() {
        return this.fullscreen;
    }

    public static class Node
    extends Entry {
        private SplitDockStation.Orientation orientation;
        private double divider;
        private Entry childA;
        private Entry childB;

        public Node(SplitDockStation.Orientation orientation, double d, Entry entry, Entry entry2) {
            this.orientation = orientation;
            this.divider = d;
            this.childA = entry;
            this.childB = entry2;
            if (entry != null) {
                entry.setParent(this);
            }
            if (entry2 != null) {
                entry2.setParent(this);
            }
        }

        public Node asNode() {
            return this;
        }

        public SplitDockPathProperty createPathProperty(Entry entry) {
            SplitDockPathProperty splitDockPathProperty = this.createPathProperty();
            if (entry == this.childA) {
                if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                    splitDockPathProperty.add(SplitDockPathProperty.Location.LEFT, this.divider);
                } else {
                    splitDockPathProperty.add(SplitDockPathProperty.Location.TOP, this.divider);
                }
            } else if (entry == this.childB) {
                if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                    splitDockPathProperty.add(SplitDockPathProperty.Location.RIGHT, 1.0 - this.divider);
                } else {
                    splitDockPathProperty.add(SplitDockPathProperty.Location.BOTTOM, 1.0 - this.divider);
                }
            }
            return splitDockPathProperty;
        }

        public SplitDockStation.Orientation getOrientation() {
            return this.orientation;
        }

        public double getDivider() {
            return this.divider;
        }

        public Entry getChildA() {
            return this.childA;
        }

        public Entry getChildB() {
            return this.childB;
        }
    }

    public static class Leaf
    extends Entry {
        private int id;

        public Leaf(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public Leaf asLeaf() {
            return this;
        }
    }

    public static abstract class Entry {
        private Node parent;

        protected void setParent(Node node) {
            this.parent = node;
        }

        public Node getParent() {
            return this.parent;
        }

        public Leaf asLeaf() {
            return null;
        }

        public Node asNode() {
            return null;
        }

        public SplitDockPathProperty createPathProperty() {
            SplitDockPathProperty splitDockPathProperty = null;
            splitDockPathProperty = this.parent != null ? this.parent.createPathProperty(this) : new SplitDockPathProperty();
            return splitDockPathProperty;
        }
    }
}

