/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockStationLayout;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockStationFactory
implements DockFactory<SplitDockStation, SplitDockStationLayout> {
    public static final String ID = "SplitDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public SplitDockStationLayout getLayout(SplitDockStation splitDockStation, final Map<Dockable, Integer> map) {
        SplitDockStationLayout.Entry entry = splitDockStation.visit(new SplitTreeFactory<SplitDockStationLayout.Entry>(){

            @Override
            public SplitDockStationLayout.Entry leaf(Dockable dockable) {
                Integer n = (Integer)map.get(dockable);
                if (n != null) {
                    return new SplitDockStationLayout.Leaf(n);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry root(SplitDockStationLayout.Entry entry) {
                return entry;
            }

            @Override
            public SplitDockStationLayout.Entry horizontal(SplitDockStationLayout.Entry entry, SplitDockStationLayout.Entry entry2, double d) {
                if (entry == null) {
                    return entry2;
                }
                if (entry2 == null) {
                    return entry;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.HORIZONTAL, d, entry, entry2);
            }

            @Override
            public SplitDockStationLayout.Entry vertical(SplitDockStationLayout.Entry entry, SplitDockStationLayout.Entry entry2, double d) {
                if (entry == null) {
                    return entry2;
                }
                if (entry2 == null) {
                    return entry;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.VERTICAL, d, entry, entry2);
            }
        });
        Dockable dockable = splitDockStation.getFullScreen();
        Integer n = null;
        if (dockable != null) {
            n = map.get(dockable);
        }
        if (n == null) {
            return new SplitDockStationLayout(entry, -1);
        }
        return new SplitDockStationLayout(entry, n);
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map) {
        SplitDockTree splitDockTree = new SplitDockTree();
        SplitDockTree.Key key = null;
        if (splitDockStationLayout.getRoot() != null) {
            key = this.handleEntry(splitDockStationLayout.getRoot(), splitDockTree, map);
        }
        if (key != null) {
            splitDockTree.root(key);
        }
        splitDockStation.dropTree(splitDockTree, false);
        Dockable dockable = map.get(splitDockStationLayout.getFullscreen());
        splitDockStation.setFullScreen(dockable);
    }

    private SplitDockTree.Key handleEntry(SplitDockStationLayout.Entry entry, SplitDockTree splitDockTree, Map<Integer, Dockable> map) {
        if (entry.asLeaf() != null) {
            return this.handleLeaf(entry.asLeaf(), splitDockTree, map);
        }
        return this.handleNode(entry.asNode(), splitDockTree, map);
    }

    private SplitDockTree.Key handleLeaf(SplitDockStationLayout.Leaf leaf, SplitDockTree splitDockTree, Map<Integer, Dockable> map) {
        Dockable dockable = map.get(leaf.getId());
        if (dockable != null) {
            return splitDockTree.put(dockable);
        }
        return null;
    }

    private SplitDockTree.Key handleNode(SplitDockStationLayout.Node node, SplitDockTree splitDockTree, Map<Integer, Dockable> map) {
        SplitDockTree.Key key = this.handleEntry(node.getChildA(), splitDockTree, map);
        SplitDockTree.Key key2 = this.handleEntry(node.getChildB(), splitDockTree, map);
        if (key == null) {
            return key2;
        }
        if (key2 == null) {
            return key;
        }
        switch (node.getOrientation()) {
            case HORIZONTAL: {
                return splitDockTree.horizontal(key, key2, node.getDivider());
            }
            case VERTICAL: {
                return splitDockTree.vertical(key, key2, node.getDivider());
            }
        }
        return null;
    }

    @Override
    public void estimateLocations(SplitDockStationLayout splitDockStationLayout, Map<Integer, DockLayoutInfo> map) {
        this.estimateLocations(splitDockStationLayout.getRoot(), map);
    }

    @Override
    private void estimateLocations(SplitDockStationLayout.Entry entry, Map<Integer, DockLayoutInfo> map) {
        Object object;
        if (entry == null) {
            return;
        }
        SplitDockStationLayout.Leaf leaf = entry.asLeaf();
        if (leaf != null && (object = map.get(leaf.getId())) != null) {
            SplitDockPathProperty splitDockPathProperty = leaf.createPathProperty();
            ((DockLayoutInfo)object).setLocation(splitDockPathProperty);
        }
        if ((object = entry.asNode()) != null) {
            this.estimateLocations(((SplitDockStationLayout.Node)object).getChildA(), map);
            this.estimateLocations(((SplitDockStationLayout.Node)object).getChildB(), map);
        }
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout) {
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout splitDockStationLayout) {
        SplitDockStation splitDockStation = this.createStation();
        this.setLayout(splitDockStation, splitDockStationLayout);
        return splitDockStation;
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map) {
        SplitDockStation splitDockStation = this.createStation();
        this.setLayout(splitDockStation, splitDockStationLayout, map);
        return splitDockStation;
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        SplitDockStationLayout.Entry entry = splitDockStationLayout.getRoot();
        if (entry == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            this.writeEntry(entry, dataOutputStream);
        }
        dataOutputStream.writeInt(splitDockStationLayout.getFullscreen());
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, DataOutputStream dataOutputStream) throws IOException {
        if (entry.asLeaf() != null) {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeInt(entry.asLeaf().getId());
        } else {
            SplitDockStationLayout.Node node = entry.asNode();
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(node.getOrientation().ordinal());
            dataOutputStream.writeDouble(node.getDivider());
            this.writeEntry(node.getChildA(), dataOutputStream);
            this.writeEntry(node.getChildB(), dataOutputStream);
        }
    }

    @Override
    public SplitDockStationLayout read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        SplitDockStationLayout.Entry entry = null;
        if (dataInputStream.readBoolean()) {
            entry = this.readEntry(dataInputStream);
        }
        int n = dataInputStream.readInt();
        return new SplitDockStationLayout(entry, n);
    }

    private SplitDockStationLayout.Entry readEntry(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return new SplitDockStationLayout.Leaf(dataInputStream.readInt());
        }
        if (by == 1) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
            double d = dataInputStream.readDouble();
            SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream);
            SplitDockStationLayout.Entry entry2 = this.readEntry(dataInputStream);
            return new SplitDockStationLayout.Node(orientation, d, entry, entry2);
        }
        throw new IOException("unknown kind: " + by);
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, XElement xElement) {
        if (splitDockStationLayout.getFullscreen() != -1) {
            xElement.addElement("fullscreen").addInt("id", splitDockStationLayout.getFullscreen());
        }
        if (splitDockStationLayout.getRoot() != null) {
            this.writeEntry(splitDockStationLayout.getRoot(), xElement);
        }
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, XElement xElement) {
        if (entry.asLeaf() != null) {
            xElement.addElement("leaf").addInt("id", entry.asLeaf().getId());
        } else {
            XElement xElement2 = xElement.addElement("node");
            xElement2.addString("orientation", entry.asNode().getOrientation().name());
            xElement2.addDouble("divider", entry.asNode().getDivider());
            this.writeEntry(entry.asNode().getChildA(), xElement2);
            this.writeEntry(entry.asNode().getChildB(), xElement2);
        }
    }

    @Override
    public SplitDockStationLayout read(XElement xElement) {
        SplitDockStationLayout.Entry entry = null;
        XElement xElement2 = xElement.getElement("node");
        if (xElement2 == null) {
            xElement2 = xElement.getElement("leaf");
        }
        if (xElement2 != null) {
            entry = this.readEntry(xElement2);
        }
        int n = -1;
        XElement xElement3 = xElement.getElement("fullscreen");
        if (xElement3 != null) {
            n = xElement3.getInt("id");
        }
        return new SplitDockStationLayout(entry, n);
    }

    private SplitDockStationLayout.Entry readEntry(XElement xElement) {
        if ("leaf".equals(xElement.getName())) {
            return new SplitDockStationLayout.Leaf(xElement.getInt("id"));
        }
        if ("node".equals(xElement.getName())) {
            if (xElement.getElementCount() != 2) {
                throw new XException("node element must have exactly two children: " + xElement);
            }
            return new SplitDockStationLayout.Node(SplitDockStation.Orientation.valueOf(xElement.getString("orientation")), xElement.getDouble("divider"), this.readEntry(xElement.getElement(0)), this.readEntry(xElement.getElement(1)));
        }
        throw new XException("element neither leaf nor node: " + xElement);
    }

    protected SplitDockStation createStation() {
        return new SplitDockStation();
    }
}

