/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockPathProperty
extends AbstractDockableProperty
implements Iterable<Node> {
    private List<Node> nodes = new LinkedList<Node>();

    @Override
    public DockableProperty copy() {
        SplitDockPathProperty splitDockPathProperty = new SplitDockPathProperty();
        for (Node node : this.nodes) {
            splitDockPathProperty.add(node.getLocation(), node.getSize());
        }
        this.copy(splitDockPathProperty);
        return splitDockPathProperty;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodes.iterator();
    }

    public int size() {
        return this.nodes.size();
    }

    public Node getNode(int n) {
        return this.nodes.get(n);
    }

    public SplitDockProperty toLocation() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        for (Node node : this.nodes) {
            switch (node.getLocation()) {
                case LEFT: {
                    d3 *= node.getSize();
                    break;
                }
                case RIGHT: {
                    d = d + d3 - d3 * node.getSize();
                    d3 *= node.getSize();
                    break;
                }
                case TOP: {
                    d4 *= node.getSize();
                    break;
                }
                case BOTTOM: {
                    d2 = d2 + d4 - d4 * node.getSize();
                    d4 *= node.getSize();
                }
            }
        }
        SplitDockProperty splitDockProperty = new SplitDockProperty(d, d2, d3, d4);
        splitDockProperty.setSuccessor(this.getSuccessor());
        return splitDockProperty;
    }

    public void add(Location location, double d) {
        this.insert(location, d, this.nodes.size());
    }

    public void insert(Location location, double d, int n) {
        if (location == null) {
            throw new NullPointerException("location must not be null");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("size must be in the range 0.0 to 1.0");
        }
        this.nodes.add(n, new Node(location, d));
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPathProperty";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeInt(this.nodes.size());
        for (Node node : this.nodes) {
            switch (node.getLocation()) {
                case LEFT: {
                    dataOutputStream.writeByte(0);
                    break;
                }
                case RIGHT: {
                    dataOutputStream.writeByte(1);
                    break;
                }
                case TOP: {
                    dataOutputStream.writeByte(2);
                    break;
                }
                case BOTTOM: {
                    dataOutputStream.writeByte(3);
                }
            }
            dataOutputStream.writeDouble(node.getSize());
        }
    }

    @Override
    public void store(XElement xElement) {
        for (Node node : this.nodes) {
            XElement xElement2 = xElement.addElement("node");
            xElement2.addString("location", node.getLocation().name());
            xElement2.addDouble("size", node.getSize());
        }
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.nodes.clear();
        int n = dataInputStream.readInt();
        while (n > 0) {
            --n;
            Location location = null;
            switch (dataInputStream.readByte()) {
                case 0: {
                    location = Location.LEFT;
                    break;
                }
                case 1: {
                    location = Location.RIGHT;
                    break;
                }
                case 2: {
                    location = Location.TOP;
                    break;
                }
                case 3: {
                    location = Location.BOTTOM;
                }
            }
            double d = dataInputStream.readDouble();
            this.nodes.add(new Node(location, d));
        }
    }

    @Override
    public void load(XElement xElement) {
        this.nodes.clear();
        for (XElement xElement2 : xElement.getElements("node")) {
            this.nodes.add(new Node(Location.valueOf(xElement2.getString("location")), xElement2.getDouble("size")));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[nodes=" + this.nodes + "]";
    }

    public static class Node {
        private double size;
        private Location location;

        public Node(Location location, double d) {
            this.location = location;
            this.size = d;
        }

        public double getSize() {
            return this.size;
        }

        public Location getLocation() {
            return this.location;
        }

        public String toString() {
            return this.getClass().getName() + "[size=" + this.size + ",location=" + (Object)((Object)this.location) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

