/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import java.awt.Dimension;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends SplitNode {
    private SplitNode left;
    private SplitNode right;
    private double divider = 0.5;
    private SplitDockStation.Orientation orientation = SplitDockStation.Orientation.VERTICAL;
    private Rectangle dividerBounds = new Rectangle();

    public Node(SplitDockAccess splitDockAccess, SplitNode splitNode, SplitNode splitNode2, SplitDockStation.Orientation orientation) {
        this(splitDockAccess, splitNode, splitNode2);
        this.orientation = orientation;
    }

    public Node(SplitDockAccess splitDockAccess, SplitNode splitNode, SplitNode splitNode2) {
        super(splitDockAccess);
        this.setRight(splitNode2);
        this.setLeft(splitNode);
    }

    public Node(SplitDockAccess splitDockAccess) {
        super(splitDockAccess);
    }

    public void setLeft(SplitNode splitNode) {
        if (this.left != null) {
            this.left.setParent(null);
        }
        this.left = splitNode;
        if (splitNode != null) {
            splitNode.delete(false);
            splitNode.setParent(this);
        }
        this.getAccess().getOwner().revalidate();
        this.getAccess().getOwner().repaint();
    }

    public SplitNode getLeft() {
        return this.left;
    }

    public void setRight(SplitNode splitNode) {
        if (this.right != null) {
            this.right.setParent(null);
        }
        this.right = splitNode;
        if (splitNode != null) {
            splitNode.delete(false);
            splitNode.setParent(this);
        }
        this.getAccess().getOwner().revalidate();
        this.getAccess().getOwner().repaint();
    }

    public SplitNode getRight() {
        return this.right;
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        if (this.left == splitNode) {
            return 0;
        }
        if (this.right == splitNode) {
            return 1;
        }
        return -1;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        if (n == 0) {
            this.setLeft(splitNode);
        } else if (n == 1) {
            this.setRight(splitNode);
        } else {
            throw new IllegalArgumentException("Location not valid " + n);
        }
    }

    public SplitDockStation.Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(SplitDockStation.Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation must not be null");
        }
        this.orientation = orientation;
        this.getAccess().getOwner().revalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.left == null ? new Dimension() : this.left.getMinimumSize();
        Dimension dimension2 = this.right == null ? new Dimension() : this.right.getMinimumSize();
        int n = this.getAccess().getOwner().getDividerSize();
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            return new Dimension(dimension.width + n + dimension2.width, Math.max(dimension.height, dimension2.height));
        }
        return new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + n + dimension2.height);
    }

    public void setDivider(double d) {
        this.divider = d;
        this.getAccess().getOwner().revalidate();
        this.getAccess().getOwner().repaint();
    }

    public double getDivider() {
        return this.divider;
    }

    @Override
    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.updateBounds(d, d2, d3, d4, d5, d6, bl);
        this.divider = this.getAccess().validateDivider(this.divider, this);
        int n = this.getAccess().getOwner().getDividerSize();
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            double d7 = d5 > 0.0 ? Math.max(0.0, (double)n / d5) : 0.0;
            double d8 = d3 * this.divider;
            if (this.left != null) {
                this.left.updateBounds(d, d2, d8 - d7 / 2.0, d4, d5, d6, bl);
            }
            if (this.right != null) {
                this.right.updateBounds(d + d8 + d7 / 2.0, d2, d3 - d8 - d7 / 2.0, d4, d5, d6, bl);
            }
            this.dividerBounds.setBounds((int)((d + d8 - d7 / 2.0) * d5 + 0.5), (int)(d2 * d6 + 0.5), n, (int)(d4 * d6 + 0.5));
        } else {
            double d9 = d6 > 0.0 ? Math.max(0.0, (double)n / d6) : 0.0;
            double d10 = d4 * this.divider;
            if (this.left != null) {
                this.left.updateBounds(d, d2, d3, d10 - d9 / 2.0, d5, d6, bl);
            }
            if (this.right != null) {
                this.right.updateBounds(d, d2 + d10 + d9 / 2.0, d3, d4 - d10 - d9 / 2.0, d5, d6, bl);
            }
            this.dividerBounds.setBounds((int)(d * d5 + 0.5), (int)((d2 + d10 - d9 / 2.0) * d6 + 0.5), (int)(d3 * d5 + 0.5), n);
        }
    }

    public Rectangle getDividerBounds(double d, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Root root = this.getRoot();
        double d2 = root.getWidthFactor();
        double d3 = root.getHeightFactor();
        int n = this.getAccess().getOwner().getDividerSize();
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            double d4 = (double)n / d2;
            double d5 = this.width * d;
            rectangle.setBounds((int)((this.x + d5 - d4 / 2.0) * d2 + 0.5), (int)(this.y * d3 + 0.5), n, (int)(this.height * d3 + 0.5));
        } else {
            double d6 = (double)n / d3;
            double d7 = this.height * d;
            rectangle.setBounds((int)(this.x * d2 + 0.5), (int)((this.y + d7 - d6 / 2.0) * d3 + 0.5), (int)(this.width * d2 + 0.5), n);
        }
        return rectangle;
    }

    public double getDividerAt(int n, int n2) {
        Root root = this.getRoot();
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            double d = (double)n / root.getWidthFactor();
            return (d - this.x) / this.width;
        }
        double d = (double)n2 / root.getHeightFactor();
        return (d - this.y) / this.height;
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            if ((double)n < (this.x + this.divider * this.width) * d) {
                return this.left == null ? null : this.left.getPut(n, n2, d, d2, dockable);
            }
            return this.right == null ? null : this.right.getPut(n, n2, d, d2, dockable);
        }
        if ((double)n2 < (this.y + this.divider * this.height) * d2) {
            return this.left == null ? null : this.left.getPut(n, n2, d, d2, dockable);
        }
        return this.right == null ? null : this.right.getPut(n, n2, d, d2, dockable);
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            if ((double)n < (this.x + this.divider * this.width) * d) {
                return this.left.isInOverrideZone(n, n2, d, d2);
            }
            return this.right.isInOverrideZone(n, n2, d, d2);
        }
        if ((double)n2 < (this.y + this.divider * this.height) * d2) {
            return this.left.isInOverrideZone(n, n2, d, d2);
        }
        return this.right.isInOverrideZone(n, n2, d, d2);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl) {
        SplitDockTree splitDockTree = key.getTree();
        if (splitDockTree.isHorizontal(key)) {
            this.orientation = SplitDockStation.Orientation.HORIZONTAL;
            this.setLeft(this.create(splitDockTree.getLeft(key), bl));
            this.setRight(this.create(splitDockTree.getRight(key), bl));
            this.setDivider(splitDockTree.getDivider(key));
        } else {
            this.orientation = SplitDockStation.Orientation.VERTICAL;
            this.setLeft(this.create(splitDockTree.getTop(key), bl));
            this.setRight(this.create(splitDockTree.getBottom(key), bl));
            this.setDivider(splitDockTree.getDivider(key));
        }
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        boolean bl;
        if (n >= splitDockPathProperty.size()) {
            return this.getAccess().drop(dockable, splitDockPathProperty.toLocation(), this);
        }
        SplitDockPathProperty.Node node = splitDockPathProperty.getNode(n);
        boolean bl2 = bl = this.orientation == SplitDockStation.Orientation.HORIZONTAL && (node.getLocation() == SplitDockPathProperty.Location.TOP || node.getLocation() == SplitDockPathProperty.Location.BOTTOM) || this.orientation == SplitDockStation.Orientation.VERTICAL && (node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.RIGHT);
        if (bl) {
            Node node2;
            Leaf leaf = this.create(dockable, true);
            if (leaf == null) {
                return false;
            }
            SplitDockStation.Orientation orientation = node.getLocation() == SplitDockPathProperty.Location.TOP || node.getLocation() == SplitDockPathProperty.Location.BOTTOM ? SplitDockStation.Orientation.VERTICAL : SplitDockStation.Orientation.HORIZONTAL;
            SplitNode splitNode = this.getParent();
            int n2 = splitNode.getChildLocation(this);
            if (node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.TOP) {
                node2 = new Node(this.getAccess(), leaf, this, orientation);
                node2.setDivider(node.getSize());
            } else {
                node2 = new Node(this.getAccess(), this, leaf, orientation);
                node2.setDivider(1.0 - node.getSize());
            }
            splitNode.setChild(node2, n2);
            return true;
        }
        if (node.getLocation() == SplitDockPathProperty.Location.LEFT || node.getLocation() == SplitDockPathProperty.Location.TOP) {
            return this.left.insert(splitDockPathProperty, n + 1, dockable);
        }
        return this.right.insert(splitDockPathProperty, n + 1, dockable);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
            return splitTreeFactory.horizontal(this.left.submit(splitTreeFactory), this.right.submit(splitTreeFactory), this.divider);
        }
        return splitTreeFactory.vertical(this.left.submit(splitTreeFactory), this.right.submit(splitTreeFactory), this.divider);
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        Leaf leaf;
        if (this.left != null && (leaf = this.left.getLeaf(dockable)) != null) {
            return leaf;
        }
        if (this.right != null) {
            return this.right.getLeaf(dockable);
        }
        return null;
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        Node node;
        if (this.dividerBounds.contains(n, n2)) {
            return this;
        }
        if (this.left != null && (node = this.left.getDividerNode(n, n2)) != null) {
            return node;
        }
        if (this.right != null) {
            return this.right.getDividerNode(n, n2);
        }
        return null;
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handleNode(this);
        this.left.visit(splitNodeVisitor);
        this.right.visit(splitNodeVisitor);
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        int n2;
        stringBuilder.append("Node[ ");
        stringBuilder.append((Object)this.orientation);
        stringBuilder.append(" ]");
        stringBuilder.append('\n');
        for (n2 = 0; n2 < n + 1; ++n2) {
            stringBuilder.append('\t');
        }
        if (this.left == null) {
            stringBuilder.append("<null>");
        } else {
            this.left.toString(n + 1, stringBuilder);
        }
        stringBuilder.append('\n');
        for (n2 = 0; n2 < n + 1; ++n2) {
            stringBuilder.append('\t');
        }
        if (this.right == null) {
            stringBuilder.append("<null>");
        } else {
            this.right.toString(n + 1, stringBuilder);
        }
    }
}

