/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Leaf
extends SplitNode {
    private DockableDisplayer displayer;
    private Dockable dockable;
    private Listener listener = new Listener();

    public Leaf(SplitDockAccess splitDockAccess) {
        super(splitDockAccess);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.displayer == null) {
            return new Dimension(0, 0);
        }
        return this.displayer.getComponent().getMinimumSize();
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        return -1;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        throw new IllegalStateException("can't add children to a leaf");
    }

    public void setDockable(Dockable dockable, boolean bl) {
        if (this.displayer != null) {
            this.getAccess().removeDisplayer(this.displayer, bl);
            this.displayer = null;
        }
        if (dockable != null) {
            this.displayer = this.getAccess().addDisplayer(dockable, bl);
        }
        if (this.dockable != null) {
            this.dockable.removeDockableListener(this.listener);
        }
        this.dockable = dockable;
        if (dockable != null) {
            dockable.addDockableListener(this.listener);
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    @Override
    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.updateBounds(d, d2, d3, d4, d5, d6, bl);
        if (bl && this.displayer != null && this.displayer != this.getAccess().getFullScreenDockable()) {
            this.displayer.getComponent().setBounds(this.getBounds());
        }
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        if (this.displayer == null) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        PutInfo putInfo = null;
        if (this.displayer.getTitle() != null) {
            int n3;
            if (this.displayer.getTitleLocation() == DockableDisplayer.Location.TOP) {
                n3 = this.displayer.getTitle().getComponent().getHeight();
                rectangle.y += n3;
                rectangle.height -= n3;
                if (n2 <= rectangle.y) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            } else if (this.displayer.getTitleLocation() == DockableDisplayer.Location.BOTTOM) {
                n3 = this.displayer.getTitle().getComponent().getHeight();
                rectangle.height -= n3;
                if (n2 >= rectangle.y + rectangle.height) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            } else if (this.displayer.getTitleLocation() == DockableDisplayer.Location.LEFT) {
                n3 = this.displayer.getTitle().getComponent().getWidth();
                rectangle.x += n3;
                rectangle.width -= n3;
                if (n <= rectangle.x) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            } else if (this.displayer.getTitleLocation() == DockableDisplayer.Location.RIGHT) {
                n3 = this.displayer.getTitle().getComponent().getWidth();
                rectangle.width -= n3;
                if (n >= rectangle.x + rectangle.width) {
                    putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable));
                }
            }
        }
        if (putInfo != null) {
            return putInfo;
        }
        float f = this.getAccess().getOwner().getSideSnapSize();
        if ((float)n > (float)rectangle.x + f * (float)rectangle.width && (float)n < (float)(rectangle.x + rectangle.width) - f * (float)rectangle.width && (float)n2 > (float)rectangle.y + f * (float)rectangle.height && (float)n2 < (float)(rectangle.y + rectangle.height) - f * (float)rectangle.height) {
            putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, dockable));
        }
        if (putInfo != null) {
            return putInfo;
        }
        putInfo = Leaf.above(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, n, n2) ? (Leaf.above(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, n, n2) ? this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TOP, dockable)) : this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.RIGHT, dockable))) : (Leaf.above(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, n, n2) ? this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.LEFT, dockable)) : this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.BOTTOM, dockable)));
        if (putInfo != null) {
            return putInfo;
        }
        return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, dockable));
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        float f = this.getAccess().getOwner().getSideSnapSize();
        Rectangle rectangle = this.getBounds();
        return !((float)n > (float)rectangle.x + f * (float)rectangle.width) || !((float)n < (float)(rectangle.x + rectangle.width) - f * (float)rectangle.width) || !((float)n2 > (float)rectangle.y + f * (float)rectangle.height) || !((float)n2 < (float)(rectangle.y + rectangle.height) - f * (float)rectangle.height);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl) {
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        if (n < splitDockPathProperty.size()) {
            Node node;
            SplitDockPathProperty.Node node2 = splitDockPathProperty.getNode(n);
            SplitDockStation.Orientation orientation = node2.getLocation() == SplitDockPathProperty.Location.LEFT || node2.getLocation() == SplitDockPathProperty.Location.RIGHT ? SplitDockStation.Orientation.HORIZONTAL : SplitDockStation.Orientation.VERTICAL;
            boolean bl = node2.getLocation() == SplitDockPathProperty.Location.RIGHT || node2.getLocation() == SplitDockPathProperty.Location.BOTTOM;
            Leaf leaf = this.create(dockable, true);
            if (leaf == null) {
                return false;
            }
            SplitNode splitNode = this.getParent();
            int n2 = splitNode.getChildLocation(this);
            if (bl) {
                node = new Node(this.getAccess(), this, leaf, orientation);
                node.setDivider(1.0 - node2.getSize());
            } else {
                node = new Node(this.getAccess(), leaf, this, orientation);
                node.setDivider(node2.getSize());
            }
            splitNode.setChild(node, n2);
            return true;
        }
        DockStation dockStation = this.getDockable().asDockStation();
        DockableProperty dockableProperty = splitDockPathProperty.getSuccessor();
        if (dockStation != null && dockableProperty != null && dockable.accept(dockStation) && dockStation.accept(dockable)) {
            boolean bl;
            MultiDockAcceptance multiDockAcceptance;
            DockController dockController = this.getAccess().getOwner().getController();
            MultiDockAcceptance multiDockAcceptance2 = multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
            if ((multiDockAcceptance == null || multiDockAcceptance.accept(dockStation, dockable)) && (bl = dockStation.drop(dockable, dockableProperty))) {
                return true;
            }
        }
        return this.getAccess().drop(dockable, splitDockPathProperty.toLocation(), this);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        return splitTreeFactory.leaf(this.getDockable());
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        if (this.displayer == null) {
            return null;
        }
        if (dockable == this.displayer.getDockable()) {
            return this;
        }
        return null;
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        return null;
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handleLeaf(this);
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        stringBuilder.append("Leaf[ ");
        if (this.dockable != null) {
            stringBuilder.append(this.dockable.getTitleText());
        }
        stringBuilder.append(" ]");
    }

    private class Listener
    extends DockableAdapter {
        private Listener() {
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            SplitDockAccess splitDockAccess = Leaf.this.getAccess();
            if (splitDockAccess != null) {
                DockTitleVersion dockTitleVersion = splitDockAccess.getTitleVersion();
                DockUtilities.exchangeTitle(Leaf.this.displayer, dockTitleVersion);
            }
        }
    }
}

