/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationLayout;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockStationFactory
implements DockFactory<ScreenDockStation, ScreenDockStationLayout> {
    public static final String ID = "screen dock";
    private WindowProvider owner;

    public ScreenDockStationFactory(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.owner = new DirectWindowProvider(window);
    }

    public ScreenDockStationFactory(WindowProvider windowProvider) {
        if (windowProvider == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        this.owner = windowProvider;
    }

    @Deprecated
    public Window getOwner() {
        return this.owner.searchWindow();
    }

    public WindowProvider getProvider() {
        return this.owner;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void estimateLocations(ScreenDockStationLayout screenDockStationLayout, Map<Integer, DockLayoutInfo> map) {
        int n = screenDockStationLayout.size();
        for (int i = 0; i < n; ++i) {
            DockLayoutInfo dockLayoutInfo = map.get(screenDockStationLayout.id(i));
            if (dockLayoutInfo == null) continue;
            ScreenDockProperty screenDockProperty = new ScreenDockProperty(screenDockStationLayout.x(i), screenDockStationLayout.y(i), screenDockStationLayout.width(i), screenDockStationLayout.height(i));
            dockLayoutInfo.setLocation(screenDockProperty);
        }
    }

    @Override
    public ScreenDockStationLayout getLayout(ScreenDockStation screenDockStation, Map<Dockable, Integer> map) {
        ScreenDockStationLayout screenDockStationLayout = new ScreenDockStationLayout();
        int n = screenDockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = screenDockStation.getDockable(i);
            Integer n2 = map.get(dockable);
            if (n2 == null) continue;
            ScreenDockWindow screenDockWindow = screenDockStation.getWindow(i);
            Rectangle rectangle = screenDockWindow.getWindowBounds();
            screenDockStationLayout.add(n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return screenDockStationLayout;
    }

    @Override
    public void setLayout(ScreenDockStation screenDockStation, ScreenDockStationLayout screenDockStationLayout) {
    }

    @Override
    public void setLayout(ScreenDockStation screenDockStation, ScreenDockStationLayout screenDockStationLayout, Map<Integer, Dockable> map) {
        int n;
        for (n = screenDockStation.getDockableCount() - 1; n >= 0; --n) {
            screenDockStation.removeDockable(n);
        }
        int n2 = screenDockStationLayout.size();
        for (n = 0; n < n2; ++n) {
            Dockable dockable = map.get(screenDockStationLayout.id(n));
            if (dockable == null) continue;
            Rectangle rectangle = new Rectangle(screenDockStationLayout.x(n), screenDockStationLayout.y(n), screenDockStationLayout.width(n), screenDockStationLayout.height(n));
            screenDockStation.addDockable(dockable, rectangle, true);
        }
    }

    @Override
    public ScreenDockStation layout(ScreenDockStationLayout screenDockStationLayout) {
        ScreenDockStation screenDockStation = this.createStation();
        this.setLayout(screenDockStation, screenDockStationLayout);
        return screenDockStation;
    }

    @Override
    public ScreenDockStation layout(ScreenDockStationLayout screenDockStationLayout, Map<Integer, Dockable> map) {
        ScreenDockStation screenDockStation = this.createStation();
        this.setLayout(screenDockStation, screenDockStationLayout, map);
        return screenDockStation;
    }

    @Override
    public void write(ScreenDockStationLayout screenDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeInt(screenDockStationLayout.size());
        int n = screenDockStationLayout.size();
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeInt(screenDockStationLayout.id(i));
            dataOutputStream.writeInt(screenDockStationLayout.x(i));
            dataOutputStream.writeInt(screenDockStationLayout.y(i));
            dataOutputStream.writeInt(screenDockStationLayout.width(i));
            dataOutputStream.writeInt(screenDockStationLayout.height(i));
        }
    }

    @Override
    public ScreenDockStationLayout read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        ScreenDockStationLayout screenDockStationLayout = new ScreenDockStationLayout();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            screenDockStationLayout.add(n2, n3, n4, n5, n6);
        }
        return screenDockStationLayout;
    }

    @Override
    public void write(ScreenDockStationLayout screenDockStationLayout, XElement xElement) {
        int n = screenDockStationLayout.size();
        for (int i = 0; i < n; ++i) {
            XElement xElement2 = xElement.addElement("child");
            xElement2.addInt("id", screenDockStationLayout.id(i));
            xElement2.addInt("x", screenDockStationLayout.x(i));
            xElement2.addInt("y", screenDockStationLayout.y(i));
            xElement2.addInt("width", screenDockStationLayout.width(i));
            xElement2.addInt("height", screenDockStationLayout.height(i));
        }
    }

    @Override
    public ScreenDockStationLayout read(XElement xElement) {
        ScreenDockStationLayout screenDockStationLayout = new ScreenDockStationLayout();
        for (XElement xElement2 : xElement.getElements("child")) {
            screenDockStationLayout.add(xElement2.getInt("id"), xElement2.getInt("x"), xElement2.getInt("y"), xElement2.getInt("width"), xElement2.getInt("height"));
        }
        return screenDockStationLayout;
    }

    protected ScreenDockStation createStation() {
        return new ScreenDockStation(this.owner);
    }
}

