/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.SwingUtilities;

public abstract class DisplayerScreenDockWindow
implements ScreenDockWindow {
    private ScreenDockStation station;
    private DockableDisplayer displayer;
    private DockController controller;
    private boolean showTitle = true;
    private DockableListener listener = new DockableAdapter(){

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            DockUtilities.exchangeTitle(DisplayerScreenDockWindow.this.displayer, DisplayerScreenDockWindow.this.station.getTitleVersion());
        }
    };

    public DisplayerScreenDockWindow(ScreenDockStation screenDockStation) {
        if (screenDockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = screenDockStation;
    }

    protected abstract void showDisplayer(DockableDisplayer var1);

    protected abstract Component getWindowComponent();

    public void setShowTitle(boolean bl) {
        if (this.showTitle != bl) {
            this.showTitle = bl;
            if (this.displayer != null) {
                if (bl) {
                    Dockable dockable = this.displayer.getDockable();
                    DockTitle dockTitle = this.station.createDockTitle(dockable);
                    if (dockTitle != null) {
                        dockable.bind(dockTitle);
                        this.displayer.setTitle(dockTitle);
                    }
                } else {
                    DockTitle dockTitle = this.displayer.getTitle();
                    if (dockTitle != null) {
                        this.displayer.setTitle(null);
                        this.displayer.getDockable().unbind(dockTitle);
                    }
                }
            }
        }
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public Dockable getDockable() {
        if (this.displayer == null) {
            return null;
        }
        return this.displayer.getDockable();
    }

    public void setDockable(Dockable dockable) {
        DockTitle dockTitle;
        if (this.displayer != null) {
            this.displayer.getDockable().removeDockableListener(this.listener);
            dockTitle = this.displayer.getTitle();
            if (dockTitle != null) {
                this.displayer.getDockable().unbind(dockTitle);
                this.displayer.setTitle(null);
            }
            this.displayer.setDockable(null);
            this.station.getDisplayers().release(this.displayer);
            this.displayer = null;
        }
        if (dockable != null) {
            dockTitle = null;
            if (this.isShowTitle() && (dockTitle = this.station.createDockTitle(dockable)) != null) {
                dockable.bind(dockTitle);
            }
            this.displayer = this.station.getDisplayers().fetch(dockable, dockTitle);
            dockable.addDockableListener(this.listener);
        }
        this.showDisplayer(this.displayer);
    }

    public void setController(DockController dockController) {
        DockTitle dockTitle;
        if (this.displayer != null && this.controller != null && (dockTitle = this.displayer.getTitle()) != null) {
            this.displayer.getDockable().unbind(dockTitle);
            this.displayer.setTitle(null);
        }
        this.controller = dockController;
        if (this.displayer != null && this.controller != null && this.isShowTitle() && (dockTitle = this.station.createDockTitle(this.displayer.getDockable())) != null) {
            this.displayer.getDockable().bind(dockTitle);
            this.displayer.setTitle(dockTitle);
        }
    }

    public Point getOffsetDrop() {
        if (this.displayer == null) {
            return null;
        }
        Insets insets = this.getDockableInsets();
        return new Point(insets.left, insets.top);
    }

    public Point getOffsetMove() {
        if (this.displayer == null) {
            return null;
        }
        DockTitle dockTitle = this.displayer.getTitle();
        if (dockTitle == null) {
            return null;
        }
        Component component = this.getWindowComponent();
        if (component == null) {
            return null;
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(dockTitle.getComponent(), point, component);
        return point;
    }

    public boolean inCombineArea(int n, int n2) {
        if (this.displayer == null) {
            return false;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.displayer.getComponent());
        return this.displayer.titleContains(point.x, point.y);
    }

    public DockController getController() {
        return this.controller;
    }

    public ScreenDockStation getStation() {
        return this.station;
    }
}

