/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class FlapWindow
extends JDialog
implements MouseListener,
MouseMotionListener {
    private DockableDisplayer displayer;
    private boolean pressed;
    private FlapDockStation station;
    private ButtonPane buttonPane;
    private FlapDropInfo dropInfo;
    private JComponent contentPane;
    private DockableListener dockableListener = new DockableAdapter(){

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            DockUtilities.exchangeTitle(FlapWindow.this.displayer, FlapWindow.this.station.getTitleVersion());
        }
    };

    public FlapWindow(FlapDockStation flapDockStation, ButtonPane buttonPane, Frame frame) {
        super(frame, false);
        OverpaintablePanel overpaintablePanel = new OverpaintablePanel(){

            protected void paintOverlay(Graphics graphics) {
                if (FlapWindow.this.dropInfo != null && FlapWindow.this.dropInfo.getCombine() != null && FlapWindow.this.dropInfo.isDraw()) {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    FlapWindow.this.station.getPaint().drawInsertion(graphics, FlapWindow.this.station, rectangle, rectangle);
                }
            }
        };
        this.setContentPane(overpaintablePanel);
        this.contentPane = overpaintablePanel.getContentPane();
        this.contentPane.setBorder(BorderFactory.createBevelBorder(0));
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.contentPane.addMouseListener(this);
        this.contentPane.addMouseMotionListener(this);
        this.contentPane.setLayout(new LayoutManager(){

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                if (FlapWindow.this.displayer == null) {
                    return new Dimension(100, 100);
                }
                return FlapWindow.this.displayer.getComponent().getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container container) {
                if (FlapWindow.this.displayer == null) {
                    return new Dimension(100, 100);
                }
                return FlapWindow.this.displayer.getComponent().getMinimumSize();
            }

            public void layoutContainer(Container container) {
                if (FlapWindow.this.displayer != null) {
                    Insets insets = container.getInsets();
                    insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
                    if (FlapWindow.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                        insets.bottom += FlapWindow.this.station.getWindowBorder();
                    } else if (FlapWindow.this.station.getDirection() == FlapDockStation.Direction.NORTH) {
                        insets.top += FlapWindow.this.station.getWindowBorder();
                    } else if (FlapWindow.this.station.getDirection() == FlapDockStation.Direction.EAST) {
                        insets.right += FlapWindow.this.station.getWindowBorder();
                    } else {
                        insets.left += FlapWindow.this.station.getWindowBorder();
                    }
                    FlapWindow.this.displayer.getComponent().setBounds(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (!FlapWindow.this.station.isFlapWindow(FlapWindow.this) || FlapWindow.this.getDockable() == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FlapWindow.this.dispose();
                        }
                    });
                }
            }
        });
        this.station = flapDockStation;
        this.buttonPane = buttonPane;
    }

    public FlapWindow(FlapDockStation flapDockStation, ButtonPane buttonPane, Dialog dialog) {
        super(dialog, false);
        OverpaintablePanel overpaintablePanel = new /* invalid duplicate definition of identical inner class */;
        this.setContentPane(overpaintablePanel);
        this.contentPane = overpaintablePanel.getContentPane();
        this.contentPane.setBorder(BorderFactory.createBevelBorder(0));
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.contentPane.addMouseListener(this);
        this.contentPane.addMouseMotionListener(this);
        this.contentPane.setLayout(new /* invalid duplicate definition of identical inner class */);
        this.addComponentListener(new /* invalid duplicate definition of identical inner class */);
        this.station = flapDockStation;
        this.buttonPane = buttonPane;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateBounds();
        }
        super.setVisible(bl);
    }

    public FlapDockStation getStation() {
        return this.station;
    }

    public void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        this.repaint();
    }

    public void setDockTitle(DockTitle dockTitle) {
        this.displayer.setTitle(dockTitle);
    }

    public DockTitle getDockTitle() {
        if (this.displayer == null) {
            return null;
        }
        return this.displayer.getTitle();
    }

    public Dockable getDockable() {
        if (this.displayer == null) {
            return null;
        }
        return this.displayer.getDockable();
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    public void setDockable(Dockable dockable) {
        Object object;
        DockElementRepresentative dockElementRepresentative;
        Container container = this.getDisplayerParent();
        if (this.displayer != null) {
            dockElementRepresentative = this.displayer.getDockable();
            object = this.displayer.getTitle();
            this.station.getDisplayers().release(this.displayer);
            container.remove(this.displayer.getComponent());
            this.displayer = null;
            if (object != null && dockElementRepresentative != null) {
                dockElementRepresentative.unbind((DockTitle)object);
            }
            if (dockElementRepresentative != null) {
                dockElementRepresentative.removeDockableListener(this.dockableListener);
            }
        }
        if (dockable != null) {
            dockElementRepresentative = null;
            object = this.station.getTitleVersion();
            if (object != null && (dockElementRepresentative = dockable.getDockTitle((DockTitleVersion)object)) != null) {
                dockable.bind((DockTitle)dockElementRepresentative);
            }
            this.displayer = this.station.getDisplayers().fetch(dockable, (DockTitle)dockElementRepresentative);
            container.add(this.displayer.getComponent());
            dockable.addDockableListener(this.dockableListener);
        }
    }

    protected Container getDisplayerParent() {
        return this.contentPane;
    }

    public Insets getDockableInsets() {
        Insets insets = this.displayer.getDockableInsets();
        this.displayer.getComponent().getBounds();
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(this.displayer.getComponent(), point, this);
        int n = point.x;
        int n2 = point.y;
        int n3 = this.getWidth() - this.displayer.getComponent().getWidth();
        int n4 = this.getHeight() - this.displayer.getComponent().getHeight();
        insets.left += n;
        insets.top += n2;
        insets.right += n3 - n;
        insets.bottom += n4 - n2;
        return insets;
    }

    public void updateBounds() {
        Dockable dockable;
        Dockable dockable2 = dockable = this.displayer == null ? null : this.displayer.getDockable();
        if (dockable != null) {
            Dimension dimension;
            Point point;
            this.validate();
            FlapDockStation.Direction direction = this.station.getDirection();
            int n = this.station.getWindowSize(dockable);
            Rectangle rectangle = this.station.getExpansionBounds();
            Insets insets = this.getDockableInsets();
            if (direction == FlapDockStation.Direction.SOUTH) {
                point = new Point(rectangle.x, rectangle.height);
                dimension = new Dimension(rectangle.width, n += insets.top + insets.bottom);
            } else if (direction == FlapDockStation.Direction.NORTH) {
                point = new Point(rectangle.x, -(n += insets.top + insets.bottom));
                dimension = new Dimension(rectangle.width, n);
            } else if (direction == FlapDockStation.Direction.WEST) {
                point = new Point(-(n += insets.left + insets.right), rectangle.y);
                dimension = new Dimension(n, rectangle.height);
            } else {
                point = new Point(rectangle.width, rectangle.y);
                dimension = new Dimension(n += insets.left + insets.right, rectangle.height);
            }
            SwingUtilities.convertPointToScreen(point, this.buttonPane);
            this.setLocation(point);
            this.setSize(dimension);
            this.validate();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.pressed) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.station.getDirection() == FlapDockStation.Direction.EAST) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressed) {
            Dockable dockable;
            Dockable dockable2 = dockable = this.displayer == null ? null : this.displayer.getDockable();
            if (dockable != null) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                Component component = this.station.getComponent();
                Point point2 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point2, component);
                int n = 0;
                n = this.station.getDirection() == FlapDockStation.Direction.SOUTH ? point.y - point2.y - component.getHeight() : (this.station.getDirection() == FlapDockStation.Direction.NORTH ? point2.y - point.y : (this.station.getDirection() == FlapDockStation.Direction.EAST ? point.x - point2.x - component.getWidth() : point2.x - point.x));
                n = Math.max(n, this.station.getWindowMinSize());
                Insets insets = this.getDockableInsets();
                n = this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH ? (n -= insets.top + insets.bottom) : (n -= insets.left + insets.right);
                if (n > 0) {
                    this.station.setWindowSize(dockable, n);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

