/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationLayout;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockStationFactory
implements DockFactory<FlapDockStation, FlapDockStationLayout> {
    public static final String ID = "flap dock";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public FlapDockStationLayout getLayout(FlapDockStation flapDockStation, Map<Dockable, Integer> map) {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n = flapDockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            object = flapDockStation.getDockable(i);
            Integer n2 = map.get(object);
            if (n2 == null) continue;
            arrayList.add(n2);
            arrayList2.add(flapDockStation.isHold((Dockable)object));
            arrayList3.add(flapDockStation.getWindowSize((Dockable)object));
        }
        int[] nArray = new int[arrayList.size()];
        boolean[] blArray = new boolean[arrayList.size()];
        object = new int[arrayList.size()];
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
            blArray[i] = (Boolean)arrayList2.get(i);
            object[i] = (Integer)arrayList3.get(i);
        }
        return new FlapDockStationLayout(nArray, blArray, (int[])object, flapDockStation.isAutoDirection(), flapDockStation.getDirection());
    }

    @Override
    public void setLayout(FlapDockStation flapDockStation, FlapDockStationLayout flapDockStationLayout) {
        flapDockStation.setDirection(flapDockStationLayout.getDirection());
        flapDockStation.setAutoDirection(flapDockStationLayout.isAutoDirection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayout(FlapDockStation flapDockStation, FlapDockStationLayout flapDockStationLayout, Map<Integer, Dockable> map) {
        DockController dockController = flapDockStation.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            for (int i = flapDockStation.getDockableCount() - 1; i >= 0; --i) {
                flapDockStation.remove(i);
            }
            flapDockStation.setDirection(flapDockStationLayout.getDirection());
            flapDockStation.setAutoDirection(flapDockStationLayout.isAutoDirection());
            int[] nArray = flapDockStationLayout.getChildren();
            boolean[] blArray = flapDockStationLayout.getHolds();
            int[] nArray2 = flapDockStationLayout.getSizes();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Dockable dockable = map.get(nArray[i]);
                if (dockable == null) continue;
                flapDockStation.add(dockable);
                flapDockStation.setHold(dockable, blArray[i]);
                flapDockStation.setWindowSize(dockable, nArray2[i]);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public void estimateLocations(FlapDockStationLayout flapDockStationLayout, Map<Integer, DockLayoutInfo> map) {
        int[] nArray = flapDockStationLayout.getChildren();
        boolean[] blArray = flapDockStationLayout.getHolds();
        int[] nArray2 = flapDockStationLayout.getSizes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            DockLayoutInfo dockLayoutInfo = map.get(nArray[i]);
            if (dockLayoutInfo == null) continue;
            FlapDockProperty flapDockProperty = new FlapDockProperty(i, blArray[i], nArray2[i]);
            dockLayoutInfo.setLocation(flapDockProperty);
        }
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout flapDockStationLayout, Map<Integer, Dockable> map) {
        FlapDockStation flapDockStation = this.createStation();
        this.setLayout(flapDockStation, flapDockStationLayout, map);
        return flapDockStation;
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout flapDockStationLayout) {
        FlapDockStation flapDockStation = this.createStation();
        this.setLayout(flapDockStation, flapDockStationLayout);
        return flapDockStation;
    }

    @Override
    public void write(FlapDockStationLayout flapDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeBoolean(flapDockStationLayout.isAutoDirection());
        dataOutputStream.writeInt(flapDockStationLayout.getDirection().ordinal());
        int n = flapDockStationLayout.getChildren().length;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeInt(flapDockStationLayout.getChildren()[i]);
            dataOutputStream.writeBoolean(flapDockStationLayout.getHolds()[i]);
            dataOutputStream.writeInt(flapDockStationLayout.getSizes()[i]);
        }
    }

    @Override
    public FlapDockStationLayout read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = dataInputStream.readBoolean();
        FlapDockStation.Direction direction = FlapDockStation.Direction.values()[dataInputStream.readInt()];
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
            blArray[i] = dataInputStream.readBoolean();
            nArray2[i] = dataInputStream.readInt();
        }
        return new FlapDockStationLayout(nArray, blArray, nArray2, bl, direction);
    }

    @Override
    public void write(FlapDockStationLayout flapDockStationLayout, XElement xElement) {
        XElement xElement2 = xElement.addElement("window");
        xElement2.addBoolean("auto", flapDockStationLayout.isAutoDirection());
        xElement2.addString("direction", flapDockStationLayout.getDirection().name());
        XElement xElement3 = xElement.addElement("children");
        int n = flapDockStationLayout.getChildren().length;
        for (int i = 0; i < n; ++i) {
            XElement xElement4 = xElement3.addElement("child");
            xElement4.addInt("id", flapDockStationLayout.getChildren()[i]);
            xElement4.addBoolean("hold", flapDockStationLayout.getHolds()[i]);
            xElement4.addInt("size", flapDockStationLayout.getSizes()[i]);
        }
    }

    @Override
    public FlapDockStationLayout read(XElement xElement) {
        int n;
        int n2;
        XElement xElement2 = xElement.getElement("window");
        XElement xElement3 = xElement.getElement("children");
        XElement[] xElementArray = xElement3.getElements("child");
        int[] nArray = new int[xElementArray.length];
        boolean[] blArray = new boolean[xElementArray.length];
        int[] nArray2 = new int[xElementArray.length];
        XAttribute xAttribute = xElement2.getAttribute("size");
        if (xAttribute != null) {
            n2 = xAttribute.getInt();
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = n2;
            }
        } else {
            n = xElementArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                nArray2[n2] = xElementArray[n2].getInt("size");
            }
        }
        n = xElementArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = xElementArray[n2].getInt("id");
            blArray[n2] = xElementArray[n2].getBoolean("hold");
        }
        return new FlapDockStationLayout(nArray, blArray, nArray2, xElement2.getBoolean("auto"), FlapDockStation.Direction.valueOf(xElement2.getString("direction")));
    }

    protected FlapDockStation createStation() {
        return new FlapDockStation();
    }
}

