/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FlapDockProperty
extends AbstractDockableProperty {
    public static final FlapDockProperty FIRST = new FlapDockProperty(0);
    public static final FlapDockProperty LAST = new FlapDockProperty(Integer.MAX_VALUE);
    private int index;
    private boolean holding = false;
    private int size = -1;

    public FlapDockProperty() {
    }

    public FlapDockProperty(int n) {
        this.setIndex(n);
    }

    public FlapDockProperty(int n, boolean bl, int n2) {
        this.setIndex(n);
        this.setHolding(bl);
        this.setSize(n2);
    }

    public DockableProperty copy() {
        FlapDockProperty flapDockProperty = new FlapDockProperty(this.index, this.holding, this.size);
        this.copy(flapDockProperty);
        return flapDockProperty;
    }

    public void setIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Index must be >= 0: " + n);
        }
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setHolding(boolean bl) {
        this.holding = bl;
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public String getFactoryID() {
        return "flap dock";
    }

    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_7);
        dataOutputStream.writeInt(this.index);
        dataOutputStream.writeBoolean(this.holding);
        dataOutputStream.writeInt(this.size);
    }

    public void store(XElement xElement) {
        xElement.addElement("index").setInt(this.index);
        xElement.addElement("holding").setBoolean(this.holding);
        if (this.size >= 0) {
            xElement.addElement("size").setInt(this.size);
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.setIndex(dataInputStream.readInt());
        if (version.compareTo(Version.VERSION_1_0_7) >= 0) {
            this.holding = dataInputStream.readBoolean();
            this.size = dataInputStream.readInt();
        } else {
            this.holding = false;
            this.size = -1;
        }
    }

    public void load(XElement xElement) {
        XElement xElement2 = xElement.getElement("index");
        XElement xElement3 = xElement.getElement("holding");
        XElement xElement4 = xElement.getElement("size");
        if (xElement2 == null && xElement3 == null) {
            this.index = xElement.getInt();
        } else {
            if (xElement2 != null) {
                this.index = xElement2.getInt();
            }
            if (xElement3 != null) {
                this.holding = xElement3.getBoolean();
            }
            this.size = xElement4 == null ? -1 : xElement4.getInt();
        }
    }
}

