/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonPane
extends OverpaintablePanel {
    private FlapDockStation station;
    private FlapDropInfo dropInfo;
    private Map<Dockable, DockTitle> buttonTitles;

    public ButtonPane(FlapDockStation flapDockStation, Map<Dockable, DockTitle> map) {
        this.setBasePane(new Content());
        this.station = flapDockStation;
        this.buttonTitles = map;
    }

    public void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        this.repaint();
    }

    public boolean titleContains(int n, int n2) {
        if (this.getComponentCount() == 0) {
            int n3;
            int n4 = this.getWidth() / 3;
            return this.contains(n - n4, n2 - (n3 = this.getHeight() / 3)) && this.contains(n + n4, n2 + n3);
        }
        int n5 = this.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Component component = this.getComponent(i);
            if (!component.contains(n - component.getX(), n2 - component.getY())) continue;
            return true;
        }
        return false;
    }

    public void resetTitles() {
        this.getContentPane().removeAll();
        int n = this.station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = this.station.getDockable(i);
            DockTitle dockTitle = this.buttonTitles.get(dockable);
            if (dockTitle == null) continue;
            this.getContentPane().add(dockTitle.getComponent());
        }
        this.revalidate();
    }

    @Override
    protected void paintOverlay(Graphics graphics) {
        if (this.dropInfo != null && this.dropInfo.isDraw() && this.dropInfo.getCombine() == null) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl;
            int n5 = this.dropInfo.getIndex() - 1;
            int n6 = n5 + 1;
            Dockable dockable = n5 < 0 ? null : this.station.getDockable(n5);
            Dockable dockable2 = n6 >= this.station.getDockableCount() ? null : this.station.getDockable(n6);
            DockTitle dockTitle = dockable == null ? null : this.buttonTitles.get(dockable);
            DockTitle dockTitle2 = dockable2 == null ? null : this.buttonTitles.get(dockable2);
            boolean bl2 = bl = this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH;
            if (dockTitle == null && dockTitle2 == null) {
                if (bl) {
                    n4 = this.getX() + this.getWidth() / 2;
                    n3 = 0;
                    n2 = n4;
                    n = this.getHeight();
                } else {
                    n4 = 0;
                    n3 = this.getY() + this.getHeight() / 2;
                    n2 = this.getWidth();
                    n = n3;
                }
            } else if (dockTitle == null) {
                if (bl) {
                    n4 = dockTitle2.getComponent().getX();
                    n3 = 0;
                    n2 = n4;
                    n = this.getHeight();
                } else {
                    n4 = 0;
                    n3 = dockTitle2.getComponent().getY();
                    n2 = this.getWidth();
                    n = n3;
                }
            } else if (dockTitle2 == null) {
                if (bl) {
                    n4 = dockTitle.getComponent().getX() + dockTitle.getComponent().getWidth();
                    n3 = 0;
                    n2 = n4;
                    n = this.getHeight();
                } else {
                    n4 = 0;
                    n3 = dockTitle.getComponent().getY() + dockTitle.getComponent().getHeight();
                    n2 = this.getWidth();
                    n = n3;
                }
            } else if (bl) {
                n4 = (dockTitle2.getComponent().getX() + dockTitle.getComponent().getX() + dockTitle.getComponent().getWidth()) / 2;
                n3 = 0;
                n2 = n4;
                n = this.getHeight();
            } else {
                n4 = 0;
                n3 = (dockTitle2.getComponent().getY() + dockTitle.getComponent().getY() + dockTitle.getComponent().getHeight()) / 2;
                n2 = this.getWidth();
                n = n3;
            }
            this.station.getPaint().drawInsertionLine(graphics, this.station, n4, n3, n2, n);
        }
    }

    public int indexAt(int n, int n2) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            int n3 = this.station.getDockableCount();
            for (int i = 0; i < n3; ++i) {
                DockTitle dockTitle = this.buttonTitles.get(this.station.getDockable(i));
                if (dockTitle == null) continue;
                int n4 = dockTitle.getComponent().getX();
                int n5 = dockTitle.getComponent().getWidth();
                if (n <= n4) {
                    return i;
                }
                if (n > n4 + n5) continue;
                if (n < n4 + n5 / 2) {
                    return i;
                }
                return i + 1;
            }
        } else {
            int n6 = this.station.getDockableCount();
            for (int i = 0; i < n6; ++i) {
                DockTitle dockTitle = this.buttonTitles.get(this.station.getDockable(i));
                if (dockTitle == null) continue;
                int n7 = dockTitle.getComponent().getY();
                int n8 = dockTitle.getComponent().getHeight();
                if (n2 <= n7) {
                    return i;
                }
                if (n2 > n7 + n8) continue;
                if (n2 < n7 + n8 / 2) {
                    return i;
                }
                return i + 1;
            }
        }
        return this.station.getDockableCount();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            int n3 = this.station.getDockableCount();
            for (int i = 0; i < n3; ++i) {
                Dockable dockable = this.station.getDockable(i);
                DockTitle dockTitle = this.buttonTitles.get(dockable);
                if (dockTitle == null) continue;
                Dimension dimension = dockTitle.getComponent().getPreferredSize();
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
        } else {
            int n4 = this.station.getDockableCount();
            for (int i = 0; i < n4; ++i) {
                Dockable dockable = this.station.getDockable(i);
                DockTitle dockTitle = this.buttonTitles.get(dockable);
                if (dockTitle == null) continue;
                Dimension dimension = dockTitle.getComponent().getPreferredSize();
                n2 += dimension.height;
                n = Math.max(n, dimension.width);
            }
        }
        return new Dimension(Math.max(10, n), Math.max(10, n2));
    }

    private class Content
    extends JPanel {
        public Content() {
            super(null);
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getWidth() - insets.left - insets.right;
            int n4 = this.getHeight() - insets.top - insets.bottom;
            if (ButtonPane.this.station.getDirection() == FlapDockStation.Direction.NORTH || ButtonPane.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                int n5;
                int n6 = this.getComponentCount();
                int[] nArray = new int[n6];
                int n7 = 0;
                int n8 = 0;
                for (n5 = 0; n5 < n6; ++n5) {
                    Dimension dimension = this.getComponent(n5).getPreferredSize();
                    nArray[n5] = dimension.width;
                    n7 = Math.max(n7, dimension.height);
                    n8 += nArray[n5];
                }
                if (ButtonPane.this.station.isSmallButtons() && n7 < n4) {
                    n5 = n4 - n7;
                    n2 += n5 / 2;
                    n4 = n7;
                }
                if (n8 > n3) {
                    double d = (double)n3 / (double)n8;
                    for (int i = 0; i < n6; ++i) {
                        int n9 = (int)((double)nArray[i] * d);
                        this.getComponent(i).setBounds(n, n2, n9, n4);
                        n += n9;
                    }
                } else {
                    for (n5 = 0; n5 < n6; ++n5) {
                        this.getComponent(n5).setBounds(n, n2, nArray[n5], n4);
                        n += nArray[n5];
                    }
                }
            } else {
                int n10;
                int n11 = this.getComponentCount();
                int[] nArray = new int[n11];
                int n12 = 0;
                int n13 = 0;
                for (n10 = 0; n10 < n11; ++n10) {
                    Dimension dimension = this.getComponent(n10).getPreferredSize();
                    nArray[n10] = dimension.height;
                    n12 = Math.max(n12, dimension.width);
                    n13 += nArray[n10];
                }
                if (ButtonPane.this.station.isSmallButtons() && n12 < n3) {
                    n10 = n3 - n12;
                    n += n10 / 2;
                    n3 = n12;
                }
                if (n13 > n4) {
                    double d = (double)n4 / (double)n13;
                    for (int i = 0; i < n11; ++i) {
                        int n14 = (int)((double)nArray[i] * d);
                        this.getComponent(i).setBounds(n, n2, n3, n14);
                        n2 += n14;
                    }
                } else {
                    for (n10 = 0; n10 < n11; ++n10) {
                        this.getComponent(n10).setBounds(n, n2, n3, nArray[n10]);
                        n2 += nArray[n10];
                    }
                }
            }
            this.repaint();
        }
    }
}

