/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayerCollection
implements Iterable<DockableDisplayer> {
    private DockStation station;
    private DockController controller;
    private DisplayerFactory factory;
    private List<DockableDisplayer> displayers = new ArrayList<DockableDisplayer>();

    public DisplayerCollection(DockStation dockStation, DisplayerFactory displayerFactory) {
        if (dockStation == null) {
            throw new IllegalArgumentException("Station must not be null");
        }
        if (displayerFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.station = dockStation;
        this.factory = displayerFactory;
    }

    @Override
    public Iterator<DockableDisplayer> iterator() {
        return this.displayers.iterator();
    }

    public DockableDisplayer fetch(Dockable dockable, DockTitle dockTitle) {
        DockableDisplayer dockableDisplayer = this.factory.create(this.station, dockable, dockTitle);
        dockableDisplayer.setTitle(dockTitle);
        dockableDisplayer.setStation(this.station);
        dockableDisplayer.setController(this.controller);
        this.displayers.add(dockableDisplayer);
        return dockableDisplayer;
    }

    public void release(DockableDisplayer dockableDisplayer) {
        this.displayers.remove(dockableDisplayer);
        dockableDisplayer.setTitle(null);
        dockableDisplayer.setDockable(null);
        dockableDisplayer.setStation(null);
        dockableDisplayer.setController(null);
    }

    public void setFactory(DisplayerFactory displayerFactory) {
        if (displayerFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.factory = displayerFactory;
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.controller = dockController;
            for (DockableDisplayer dockableDisplayer : this.displayers) {
                dockableDisplayer.setController(dockController);
            }
        }
    }
}

