/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.PropertyKey;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import javax.swing.SwingUtilities;

public abstract class AbstractDockableStation
extends AbstractDockable
implements DockStation {
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;

    public AbstractDockableStation() {
        super(PropertyKey.DOCK_STATION_ICON, PropertyKey.DOCK_STATION_TITLE, PropertyKey.DOCK_STATION_TOOLTIP);
    }

    public AbstractDockableStation(DockTheme dockTheme) {
        this();
        this.theme = dockTheme;
    }

    public DockStation asDockStation() {
        return this;
    }

    public DockTheme getTheme() {
        return this.theme;
    }

    public void updateTheme() {
        DockTheme dockTheme;
        DockController dockController = this.getController();
        if (dockController != null && (dockTheme = dockController.getTheme()) != this.theme) {
            this.theme = dockTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    public DockTitle getDockTitle(DockTitleVersion dockTitleVersion) {
        return dockTitleVersion.createStation(this);
    }

    public DockActionSource getDirectActionOffers(Dockable dockable) {
        return null;
    }

    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        return null;
    }

    public void addDockStationListener(DockStationListener dockStationListener) {
        this.listeners.addListener(dockStationListener);
    }

    public void removeDockStationListener(DockStationListener dockStationListener) {
        this.listeners.removeListener(dockStationListener);
    }

    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible();
    }

    public boolean isStationVisible() {
        Dockable dockable = this.asDockable();
        if (dockable == null) {
            return true;
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return true;
        }
        return dockStation.isVisible(dockable);
    }

    public boolean accept(Dockable dockable) {
        return true;
    }

    public boolean canCompare(DockStation dockStation) {
        return false;
    }

    public int compare(DockStation dockStation) {
        return 0;
    }

    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        dockTitle.changed(new DockTitleEvent(this, dockable, bl));
    }

    public Rectangle getStationBounds() {
        Component component = this.getComponent();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, component);
        return new Rectangle(point.x, point.y, component.getWidth(), component.getHeight());
    }
}

