/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.DockTitle;
import java.io.IOException;

public abstract class AbstractDockStation
implements DockStation {
    private DockController controller;
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;

    public void setController(DockController dockController) {
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public DockTheme getTheme() {
        return this.theme;
    }

    public void updateTheme() {
        DockTheme dockTheme;
        DockController dockController = this.getController();
        if (dockController != null && (dockTheme = dockController.getTheme()) != this.theme) {
            this.theme = dockTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    public void addDockStationListener(DockStationListener dockStationListener) {
        this.listeners.addListener(dockStationListener);
    }

    public void removeDockStationListener(DockStationListener dockStationListener) {
        this.listeners.removeListener(dockStationListener);
    }

    public boolean isVisible(Dockable dockable) {
        return true;
    }

    public boolean isStationVisible() {
        Dockable dockable = this.asDockable();
        if (dockable == null) {
            return true;
        }
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return true;
        }
        return dockStation.isStationVisible();
    }

    public boolean accept(Dockable dockable) {
        return true;
    }

    public boolean canCompare(DockStation dockStation) {
        return false;
    }

    public int compare(DockStation dockStation) {
        return 0;
    }

    public void changed(Dockable dockable, DockTitle dockTitle, boolean bl) {
        dockTitle.changed(new DockTitleEvent(this, dockable, bl));
    }
}

