/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.event;

import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.LocatedListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatedListenerList<L extends LocatedListener> {
    private List<L> listeners = new ArrayList<L>();

    public void addListener(L l) {
        this.listeners.add(l);
    }

    public void removeListener(L l) {
        this.listeners.remove(l);
    }

    public List<L> affected(DockElement dockElement) {
        LinkedList<LocatedListener> linkedList = new LinkedList<LocatedListener>();
        for (LocatedListener locatedListener : this.listeners) {
            DockElement dockElement2 = locatedListener.getTreeLocation();
            if (dockElement2 == null) {
                linkedList.add(locatedListener);
                continue;
            }
            if (dockElement == null || !DockUtilities.isAncestor(dockElement2, dockElement)) continue;
            linkedList.add(locatedListener);
        }
        Collections.sort(linkedList, new Comparator<L>(){

            @Override
            public int compare(L l, L l2) {
                DockElement dockElement;
                DockElement dockElement2 = l.getTreeLocation();
                if (dockElement2 == (dockElement = l2.getTreeLocation())) {
                    return 0;
                }
                if (dockElement2 == null) {
                    return -1;
                }
                if (dockElement == null) {
                    return 1;
                }
                if (DockUtilities.isAncestor(dockElement2, dockElement)) {
                    return -1;
                }
                return 1;
            }
        });
        return linkedList;
    }
}

