/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDockable
implements Dockable {
    private DockStation parent;
    private DockController controller;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockHierarchyObserver hierarchyObserver;
    private PropertyValue<String> titleText;
    private PropertyValue<Icon> titleIcon;
    private PropertyValue<String> titleToolTip;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private DockableDisplayerHints hints;
    private DockActionSource source;
    private HierarchyDockActionSource globalSource;

    protected AbstractDockable(PropertyKey<Icon> propertyKey, PropertyKey<String> propertyKey2, PropertyKey<String> propertyKey3) {
        this.titleIcon = new PropertyValue<Icon>(propertyKey){

            @Override
            protected void valueChanged(Icon icon, Icon icon2) {
                AbstractDockable.this.fireTitleIconChanged(icon, icon2);
            }
        };
        this.titleText = new PropertyValue<String>(propertyKey2){

            @Override
            protected void valueChanged(String string, String string2) {
                if (string == null) {
                    string = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                AbstractDockable.this.fireTitleTextChanged(string, string2);
            }
        };
        this.titleToolTip = new PropertyValue<String>(propertyKey3){

            @Override
            protected void valueChanged(String string, String string2) {
                AbstractDockable.this.fireTitleTooltipChanged(string, string2);
            }
        };
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        if (this.parent != dockStation) {
            this.parent = dockStation;
            this.hierarchyObserver.update();
        }
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        this.titleIcon.setProperties(dockController);
        this.titleText.setProperties(dockController);
        this.hierarchyObserver.controllerChanged(dockController);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addDockableListener(DockableListener dockableListener) {
        this.dockableListeners.add(dockableListener);
    }

    @Override
    public void removeDockableListener(DockableListener dockableListener) {
        this.dockableListeners.remove(dockableListener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.addDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener dockHierarchyListener) {
        this.hierarchyObserver.removeDockHierarchyListener(dockHierarchyListener);
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.getComponent().addMouseListener(mouseInputListener);
        this.getComponent().addMouseMotionListener(mouseInputListener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.getComponent().removeMouseListener(mouseInputListener);
        this.getComponent().removeMouseMotionListener(mouseInputListener);
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return true;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return true;
    }

    @Override
    public String getTitleText() {
        String string = this.titleText.getValue();
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setTitleText(String string) {
        this.titleText.setValue(string);
    }

    @Override
    public Icon getTitleIcon() {
        return this.titleIcon.getValue();
    }

    public void setTitleToolTip(String string) {
        this.titleToolTip.setValue(string);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public void setTitleIcon(Icon icon) {
        this.titleIcon.setValue(icon);
    }

    @Override
    public DockTitle getDockTitle(DockTitleVersion dockTitleVersion) {
        return dockTitleVersion.createDockable(this);
    }

    @Override
    public void bind(DockTitle dockTitle) {
        if (this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(dockTitle);
        this.fireTitleBound(dockTitle);
    }

    @Override
    public void unbind(DockTitle dockTitle) {
        if (!this.titles.contains(dockTitle)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(dockTitle);
        this.fireTitleUnbound(dockTitle);
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return this.source;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    public void setActionOffers(DockActionSource dockActionSource) {
        this.source = dockActionSource;
        this.globalSource.update();
    }

    protected void fireTitleTextChanged(String string, String string2) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleTextChanged(this, string, string2);
        }
    }

    protected void fireTitleTooltipChanged(String string, String string2) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleToolTipChanged(this, string, string2);
        }
    }

    protected void fireTitleIconChanged(Icon icon, Icon icon2) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleIconChanged(this, icon, icon2);
        }
    }

    protected void fireTitleBound(DockTitle dockTitle) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleBound(this, dockTitle);
        }
    }

    protected void fireTitleUnbound(DockTitle dockTitle) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleUnbound(this, dockTitle);
        }
    }

    protected void fireTitleExchanged(DockTitle dockTitle) {
        for (DockableListener dockableListener : this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()])) {
            dockableListener.titleExchanged(this, dockTitle);
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] dockTitleArray;
        for (DockTitle dockTitle : dockTitleArray = this.listBoundTitles()) {
            this.fireTitleExchanged(dockTitle);
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        this.hints = dockableDisplayerHints;
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }
}

