/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRelocatorAdapter;

public class SingleParentRemover {
    private DockRelocatorObserver dockRelocatorObserver = new DockRelocatorObserver();
    private DockRegisterObserver dockRegisterObserver = new DockRegisterObserver();
    private boolean onTest = false;

    public void install(DockController dockController) {
        dockController.getRelocator().addDockRelocatorListener(this.dockRelocatorObserver);
        dockController.getRegister().addDockRegisterListener(this.dockRegisterObserver);
        this.testAll(dockController);
    }

    public void uninstall(DockController dockController) {
        dockController.getRelocator().removeDockRelocatorListener(this.dockRelocatorObserver);
        dockController.getRegister().removeDockRegisterListener(this.dockRegisterObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAll(DockController dockController) {
        if (this.onTest) {
            return;
        }
        try {
            this.onTest = true;
            dockController.getRegister().setStalled(true);
            int n = 0;
            while (n < dockController.getRegister().getStationCount()) {
                if (this.test(dockController.getRegister().getStation(n))) {
                    n = 0;
                    continue;
                }
                ++n;
            }
        }
        finally {
            dockController.getRegister().setStalled(false);
            this.onTest = false;
        }
    }

    protected boolean shouldTest(DockStation dockStation) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test(DockStation dockStation) {
        DockController dockController = dockStation.getController();
        if (dockController != null) {
            dockController.getRegister().setStalled(true);
        }
        try {
            if (!this.shouldTest(dockStation)) {
                boolean bl = false;
                return bl;
            }
            if (dockStation.getDockableCount() > 1) {
                boolean bl = false;
                return bl;
            }
            Dockable dockable = dockStation.asDockable();
            if (dockable == null) {
                boolean bl = false;
                return bl;
            }
            DockStation dockStation2 = dockable.getDockParent();
            if (dockStation2 == null) {
                boolean bl = false;
                return bl;
            }
            if (dockStation2.getController() == null) {
                boolean bl = false;
                return bl;
            }
            if (dockStation.getDockableCount() == 0) {
                if (!dockStation2.canDrag(dockable)) {
                    boolean bl = false;
                    return bl;
                }
                dockStation2.drag(dockable);
                boolean bl = true;
                return bl;
            }
            Dockable dockable2 = dockStation.getDockable(0);
            if (!dockStation.canDrag(dockable2)) {
                boolean bl = false;
                return bl;
            }
            if (!dockStation2.accept(dockable2) || !dockable2.accept(dockStation2)) {
                boolean bl = false;
                return bl;
            }
            if (!dockStation2.canReplace(dockable, dockable2)) {
                boolean bl = false;
                return bl;
            }
            MultiDockAcceptance multiDockAcceptance = dockStation.getController().getAcceptance();
            if (multiDockAcceptance != null && !multiDockAcceptance.accept(dockStation2, dockable2)) {
                boolean bl = false;
                return bl;
            }
            dockStation.drag(dockable2);
            dockStation2.replace(dockable, dockable2);
            boolean bl = true;
            return bl;
        }
        finally {
            if (dockController != null) {
                dockController.getRegister().setStalled(false);
            }
        }
    }

    private class DockRelocatorObserver
    extends DockRelocatorAdapter {
        private DockRelocatorObserver() {
        }

        public void drop(DockController dockController, Dockable dockable, DockStation dockStation) {
            SingleParentRemover.this.testAll(dockController);
        }
    }

    private class DockRegisterObserver
    extends DockRegisterAdapter {
        private DockRegisterObserver() {
        }

        public void dockableCycledRegister(DockController dockController, Dockable dockable) {
            SingleParentRemover.this.testAll(dockController);
        }

        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            if (!dockController.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(dockController);
            }
        }
    }
}

